   *              _\|/_
                   (o o)
    +----oOO-{_}-OOo----------------------------------------------------------------------------+
    :                                                                                                                        :
    :    BICOrdinalLogistic  (version 1.1 July 2011)                                                  :
    :                                                                                                                      :
    :    Bayesian Information Criterion for Ordinal Logistic Regression                  :
    :                                                                                                                     :
    :		http://www.medicine.mcgill.ca/epidemiology/Joseph/PBelisle                :
    +--------------------------------------------------------------------------------------------;


/* ===================================================================================================================================================
	Limitations:
	-------------
	- interaction terms of order > 2 are not allowed 
	- interaction terms involving class variables are not allowed 
*/;


%macro BICOrdinalLogistic(outModels=, outParms=, data=, outcome=, indep=, force=, level=0.95);
	%local dsAllParameterEstimates dsBICData dsBuffer dsContents dsContentsContents dsConvergenceStatus dsFitStatistics 
		dsModel dsModels dsOrder2 dsOrder2a dsOrder2b  dsParameterEstimates dsTmp dsVarsOrder0 dsVarsOrder dsxterms dsxvars;

	%local alpha anyclassval0 anylabel anyvarNotFound bicmodel classvars converged datalxvar definedMinus2LogLNULL fullmodel HigherOrder indepNoSpace it itm;
	%local lindep lmodel lxterms m mindep minus2logL minus2logLNULL model modelok mxterms  nClassvars nClassvarsInterns niternterms nmodels notfound nSubjects nterms order1vars order2terms;
	%local level100 p parmname pNull strmodel t v x xtermsNoSpace  z;

	%let indepNoSpace = %sysfunc(compbl(%sysfunc(translate(&indep &force, %str( ), %str(*)))));

	%let lindep	= %BIClmax(&indepNoSpace);
	%let mindep	= %BICntokens(&indepNoSpace);
	%let definedMinus2LogLNULL = 0;

	%let dsBuffer	= %BICNewDatasetName(buffer);
	%let dsxvars		= %BICNewDatasetName(xvars);

	%if %length(%superq(outModels)) eq 0 %then %do;
		%put ERROR: outModels= argument must be defined;
	%end;
	%if %length(%superq(outParms)) eq 0 %then %do;
		%put ERROR: outParms= argument must be defined;
	%end;
	%if %length(%superq(data)) eq 0 %then %do;
		%put ERROR: data= argument must be defined;
	%end;
	%if %length(%superq(outcome)) eq 0 %then %do;
		%put ERROR: outcome= argument must be defined;
	%end;
	%if %length(%superq(indep)) eq 0 %then %do;
		%put ERROR: indep= argument must be defined;
	%end;

	/*
	%if &sysver >= 9.2 %then %let parmname = Parameter;
	%else %let parmname = Variable;
	*/

	* Reserve output file names;
	data &outModels; stop; run;
	data &outParms; stop; run;

	%let parmname = Variable;

	%let z = probit((1+&level)/2);
	%let level100 = %sysevalf(100*&level);

	data &dsxvars;
		length name $&lindep;
		%do v = 1 %to &mindep;
			%let x = %scan(&indepNoSpace, &v);
			name = "&x";
			ucname = upcase(name);
			output;
		%end;
	run;

	%let dsContents = %BICNewDatasetName(contents);

	proc contents data=&data out=&dsContents (keep=name format length varnum type) noprint; run;
	data &dsContents (drop=name);
		set &dsContents;
		ucname = upcase(name);
		IsFactor = not missing(format) or type eq 2;
	run;

	%let dsContentsContents = %BICNewDatasetName(contents);

	proc contents data=&dsContents out=&dsContentsContents (keep=name length) noprint; run;

	proc sql noprint;
		select length into :datalxvar
		from &dsContentsContents
		where upcase(name) eq "UCNAME";
	quit;

	proc sort data=&dsContents;		by ucname; run;
	proc sort data=&dsxvars;			by ucname; run;

	* Merge data sets with varnames;

	proc sql;
		create table &dsBuffer as
		select a.*, b.IsFactor, not missing(b.IsFactor) as inData, b.varnum
		from &dsxvars as a
		left join &dsContents as b
		on a.ucname = b.ucname;
	quit;
	proc datasets nolist; delete &dsxvars; change &dsBuffer=&dsxvars; quit;

	proc sql noprint;
		select min(inData) = 0 into :anyvarNotFound
		from &dsxvars;
	quit;

	%if &anyvarNotFound = 1 %then %do;
		proc sql noprint;
			select name into :notfound separated by ','
			from &dsxvars
			where inData = 0;
		quit;

		%put ERROR: variable(s) [&notfound] not found in data set &data;
		%goto skip;
	%end;

	proc sort data=&dsxvars; by varnum; run;
	data &dsxvars;
		set &dsxvars;
		by varnum;
		if first.varnum;
	run;

	proc sql noprint;
		select name into :order1vars separated by ' '
		from &dsxvars;
	quit;

	* Make sure that no interaction term of order > 2 was given in model;

	%let xtermsNoSpace = %sysfunc(tranwrd(%sysfunc(tranwrd(%sysfunc(compbl(&indep &force)),%str( *), %str(*))), %str(* ), %str(*)));

	%let lxterms	= %BIClmax(&xtermsNoSpace);
	%let mxterms	= %BICntokens(&xtermsNoSpace);

	%let dsxterms = %BICNewDatasetName(xterms0);

	data &dsxterms;
		length name $&lxterms;
		%do v = 1 %to &mxterms;
			%let x = %scan(&xtermsNoSpace, &v, %str( ));
			name = "&x";
			ucname = upcase(name);
			order = 1 + length(ucname) - length(compress(ucname,"*"));
			output;
		%end;
	run;

	%let dsVarsOrder0 = %BICNewDatasetName(VarsOrder0);

	data &dsVarsOrder0 (drop=_star _ucname);
		set &dsxterms (drop=name);
		if order = 2 then do;
			_ucname = ucname;
			_star = index(ucname, "*");
			ucname = substr(_ucname, 1, _star - 1);
			output;
			ucname = substr(_ucname, _star + 1);
			output;
		end;
		else output;
	run;

	%let dsVarsOrder = %BICNewDatasetName(VarsOrder);

	proc sql;
		create table &dsVarsOrder as
		select ucname, max(order) as order
		from &dsVarsOrder0
		group ucname;
	quit;

	* Crash if any interaction term involves categorical variables;

	proc sql noprint;
		select a.name, N(a.name) into :classvars separated by ',', :nClassvarsInterns
		from &dsxvars as a, &dsVarsOrder as b
		where a.ucname = b.ucname and a.IsFactor and b.order > 1;
	quit;

	%if &nClassvarsInterns %then %do;
		%put ERROR: class variable(s) [&classvars] are are not allowed in interaction terms in the current version of BICOrdinalLogistic;
		%goto skip;
	%end;

	* Count number of class variables;

	proc sql noprint;
		select name, N(name) into :classvars separated by ' ', :nClassvars
		from &dsxvars
		where IsFactor;
	quit;

	* Crash if any order > 2;

	proc sql noprint;
		select max(order) into :HigherOrder
		from &dsVarsOrder;
	quit;

	%if &HigherOrder > 2 %then %do;
		%put ERROR: Terms of order > 2 not allowed in current version. Sorry.;
		%goto skip;
	%end;

	%if &HigherOrder > 1 %then %do;
		%let dsOrder2 = %BICNewDatasetName(order2);

		proc sql;
			create table &dsOrder2 as
			select name, ucname
			from &dsxterms
			where order = 2;
		quit;

		data &dsOrder2;
			set &dsOrder2;
			ucname1 = scan(ucname, 1);
			ucname2 = scan(ucname, 2);
		run;

		%let dsOrder2a = %BICNewDatasetName(order2);

		proc sql;
			create table &dsOrder2a as
			select a.*, b.varnum as varnum1
			from &dsOrder2 as a, &dsxvars as b
			where a.ucname1 = b.ucname;
		quit;

		%let dsOrder2b = %BICNewDatasetName(order2);

		proc sql;
			create table &dsOrder2b as
			select a.*, b.varnum as varnum2
			from &dsOrder2a as a, &dsxvars as b
			where a.ucname2 = b.ucname;
		quit;

		data &dsOrder2b;
			set &dsOrder2b;
			if varnum1 > varnum2 then ucname = catx("*", ucname2, ucname1);
		run;

		proc sort data=&dsOrder2b; by ucname; run;
		
		data &dsorder2b;
			set &dsOrder2b;
			by ucname;
			if first.ucname;
		run;

		proc sql noprint;
			select name into :order2terms separated by ' '
			from &dsOrder2b;
		quit;

		proc datasets nolist; delete &dsOrder2 &dsOrder2a &dsOrder2b; run;
	%end;

	%let fullmodel = &order1vars &order2terms;

	* Model is now certified, let-s start the real work!;

	%let nterms	= %BICntokens(&fullmodel);
	%let nmodels	= %eval(2**&nterms);
	%let alpha		= %sysevalf(1-&level);

	%let dsAllParameterEstimates	= %BICNewDatasetName(AllParms);
	%let dsBICData						= %BICNewDatasetName(BICData);
	%let dsConvergenceStatus		= %BICNewDatasetName(ConvergenceStatus);
	%let dsFitStatistics					= %BICNewDatasetName(FitStatistics);
	%let dsModel							= %BICNewDatasetName(model);
	%let dsModels							= %BICNewDatasetName(models);
	%let dsParameterEstimates		= %BICNewDatasetName(ParameterEstimates);
	%let dsTmp								= %BICNewDatasetName(tmp);

	proc sql;
		create table &dsBICData as
		select *
		from &data
		where CMiss(%BICcommasep(&outcome &order1vars)) = 0;
	quit;

	proc sql noprint;
		select N(&outcome), N(distinct &outcome) - 1 into :nSubjects, :pNull
		from &dsBICData;
	quit;

	%let lmodel	= %length(&fullmodel);
	
	* ~ * ~ * ~ * ~ * ~ * ~ *;

	%do m = &nmodels %to 1 %by -1;
		%let model = %BICCombination(&m, &fullmodel);

		%if %length(&model) = 0 %then %do;
			%let bicmodel =;
			%let strmodel=NULL;
			%let p = &pNull;

			%if %length(&force) > 0 %then %do;
				%let modelok = 0;
			%end;
			%else %do;
				%let modelok = 1;
			%end;
		%end;
		%else %do;
			%let strmodel = %BICcommasepNoSpace(&model);
			%let p = %sysevalf(&pNull+1);
			%BICOrdinalLogisticModelIsOk(modelok, bicmodel, &model, &force);
		%end;


		%if &modelok = 1 %then %do;
			%let minus2logL = -9999;
			%let converged = -9;

			%if &p > &pNull %then %do;
				ods exclude all;

				proc logistic data=&dsBICData descending;
					%if &nClassvars gt 0 %then %do;
						class &classvars / param=ref ref=first;
					%end;
					model &outcome = &bicmodel / link=clogit alpha=&alpha;
					ods output FitStatistics=&dsFitStatistics ParameterEstimates=&dsParameterEstimates ConvergenceStatus=&dsConvergenceStatus;
				run;

				ods output clear;
				ods exclude none;

				proc sql noprint;
					select N(Estimate) into :p
					from &dsParameterEstimates;
				quit;

				proc sql noprint;
					select InterceptAndCovariates into :minus2logL
					from &dsFitStatistics
					where upcase(Criterion) eq "-2 LOG L";
				quit;

				%if &definedMinus2LogLNULL = 0 %then %do;
					proc sql noprint;
						select InterceptOnly into :minus2logLNULL
						from &dsFitStatistics
						where upcase(Criterion) eq "-2 LOG L";
					quit;
					%let definedMinus2LogLNULL = 1;
				%end;

				proc sql noprint;
					select status into :converged
					from &dsConvergenceStatus;
				quit;

				proc contents data=&dsParameterEstimates out=&dsBuffer (keep=name) noprint; run;
				proc sql noprint; 
					select N(name) into :anylabel from &dsBuffer where upcase(name) eq "LABEL";
					select N(name) into :anyclassval0 from &dsBuffer where upcase(name) eq "CLASSVAL0";
					* ClassVal0 is not a member of ParameterEstimates if outcome variable was dichotomous;
				quit;
				proc datasets nolist; delete &dsBuffer; quit;


				proc sql;
					create table &dsTmp as
					select &parmname, 
						%if &anyclassval0 eq 0 %then %do;
						  "" as
						%end;
							ClassVal0,
						Estimate, StdErr, exp(Estimate) as OddsRatio, exp(Estimate-&z*StdErr) as OddsRatioLowerCL label="&level100% Odds Ratio Lower CL", 
						exp(Estimate+&z*StdErr) as OddsRatioUpperCL label="&level100% Odds Ratio Upper CL"
						%if &anylabel %then %do;
							, label
						%end;
					from &dsParameterEstimates
					where &parmname ne "Intercept";
				quit;
				proc datasets nolist; delete &dsParameterEstimates; change &dsTmp=&dsParameterEstimates; quit;

				data &dsParameterEstimates;
					length model $ &lmodel;
					set &dsParameterEstimates;
					Model = "&strmodel";
				run;

				proc datasets nolist; delete &dsConvergenceStatus &dsFitStatistics; run;
			%end;
			%else %do;
				* p = &pNull;
				%let minus2logL	= &minus2logLNULL;
				%let converged	= 0;
			%end;

			data &dsModel;
				length Model $ &lmodel;
				Model = "&strmodel";
				Converged = (&converged = 0);
				BIC = &minus2logL + &p * log(&nSubjects);
				minus2logL = &minus2logL;
				p = &p;
			run;

			%if %sysfunc(exist(&dsAllParameterEstimates)) = 0 %then %do;
				proc datasets nolist; change &dsParameterEstimates=&dsAllParameterEstimates &dsModel=&dsModels; run;
			%end;
			%else %if &p > &pNull %then %do;
				proc sql;
					create table &dsBuffer as
					select * from &dsParameterEstimates
					outer union corresponding
					select * from &dsAllParameterEstimates;
				quit;
				proc datasets nolist; delete &dsParameterEstimates &dsAllParameterEstimates; change &dsBuffer=&dsAllParameterEstimates; quit;

				proc sql;
					create table &dsBuffer as
					select * from &dsModel
					outer union corresponding
					select * from &dsModels;
				quit;
				proc datasets nolist; delete &dsModel &dsModels; change &dsBuffer=&dsModels; quit;
			%end;
			%else %do;
				proc sql;
					create table &dsBuffer as
					select * from &dsModel
					outer union corresponding
					select * from &dsModels;
				quit;
				proc datasets nolist; delete &dsModel &dsModels; change &dsBuffer=&dsModels; quit;
			%end;
		%end;
	%end;


	%if %sysfunc(exist(&outModels)) > 0 %then %do;
		proc datasets nolist; delete &outModels; quit;
	%end;

	%if %sysfunc(exist(&outParms)) > 0 %then %do;
		proc datasets nolist; delete &outParms; run;
	%end;

	proc sql;
		create table &outModels as
		select *, p eq &pNull as IsNullModel
		from &dsModels;
	quit;
	proc datasets nolist; delete &dsModels; quit;

	%if &nClassvars gt 0 %then %do;
		proc contents data=&dsAllParameterEstimates out=&dsBuffer (keep=name) noprint; run;
		proc sql noprint; select N(name) into :anylabel from &dsBuffer where upcase(name) eq "LABEL"; quit;
		proc datasets nolist; delete &dsBuffer; quit;

		proc sql;
			create table &outParms as
			select *, 
				%if &anylabel %then %do;
					coalesce(label, &parmname)
				%end;
				%else %do;
					&parmname
				%end;
				as tmp&parmname
			from &dsAllParameterEstimates;
		quit;
		proc datasets nolist; delete &dsAllParameterEstimates; quit;
		proc sql; alter table &outParms drop &parmname; quit;
		proc datasets nolist; modify &outParms; rename tmp&parmname=&parmname; quit;
	%end;
	%else %do;
		proc datasets nolist; change &dsAllParameterEstimates=&outParms; run;
	%end;

	proc datasets nolist; delete &dsBICData; run;

	%skip:
	proc datasets nolist; delete &dsContents &dsContentsContents &dsVarsOrder0 &dsVarsOrder &dsxvars &dsxterms; run;
%mend;


%macro BICOrdinalLogisticReport(models=, parms=, where=round(ModelProb,.0001) gt 0.01, EstFmt=5.2, colsepcolor=#FFE666, orfmt=5.2);
	%local dsBuffer dsCompleteVarsModelsList dsCondPostMoments dsContents dsConvergedModels 
		dsDetails dsFirstModelOut dsModelRanks dsModels dsParms dsParmsContents dsParms2Report dsPostprob 
		dsThisParmEstimates dsTmp dsTmpConvergedModels dsTmpParms dsTotPostMoments;
	%local anyclassval0 j jmax level level0 level1 level100 lmax lmodel lvar ModelRanks nmodels NullModelIsIn nvars parmname pDegenerate probs r rank somevar v var vars;

	/*
		use with where=									(undefined) to report each model 
		use with where=ModelRank le 15				(e.g.) to report only the 15 first models 
	*/;

	%if %length(%superq(models)) eq 0 %then %do;
		%put ERROR: models= argument must be defined;
	%end;
	%if %length(%superq(parms)) eq 0 %then %do;
		%put ERROR: parms= argument must be defined;
	%end;

	/*
	%if &sysver >= 9.2 %then %let parmname = Parameter;
	%else %let parmname = Variable;
	*/
	%let parmname = Variable;
	%let ucparmname=%upcase(&parmname); 

	%let dsParmsContents = %BICNewDatasetName(ParmsContents);
	proc contents data=&Parms out=&dsParmsContents (keep=name label) noprint; run;

	proc sql noprint;
		select input(scan(label, 1, " "), percent.) into :level
		from &dsParmsContents
		where upcase(name) eq "ODDSRATIOLOWERCL";
	quit;

	%let level0		= %sysevalf((1-&level)/2);
	%let level1		= %sysevalf((1+&level)/2);
	%let probs 	= &level0 0.5 &level1;
	%let level100 = %sysevalf(100*&level);

	proc sql noprint;
		select max(IsNullModel) eq 1 into :NullModelIsIn
		from &Models;
	quit;

	%let dsModels = %BICNewDatasetName(models);

	data &dsModels;
		set &Models;
		if not Converged then do;
			minus2logL = .;
			BIC = .;
		end;
	run;
	proc sort data=&dsModels; by descending Converged BIC p; run;

	data &dsModels;
		set &dsModels;
		if Converged then ModelRank = _N_;
	run;

	%let dsTmpConvergedModels = %BICNewDatasetName(converged);

	proc sql;
		create table &dsTmpConvergedModels as
		select *, BIC - min(BIC) as BIC0,  exp(-(calculated BIC0)/2) as _p
		from &dsModels
		where Converged = 1;
	quit;

	%let dsConvergedModels = %BICNewDatasetName(converged);

	proc sql;
		create table &dsConvergedModels as
		select *, _p /sum(_p) as ModelProb
		from &dsTmpConvergedModels;
	quit;

	%let dsTmpParms = %BICNewDatasetName(tmpparms);

	proc sql;
		create table &dsTmpParms as
		select *, 0 as NullModel
		from &Parms;
	quit;

	proc sql noprint;
		select max(length(model)) into :lmodel
		from &Parms;
	quit;

	%if &NullModelIsIn %then %do;
		* NULL model is in: add it to dsTmpParms;

		%if &lmodel < 4 %then %let lmodel = 4;

		proc sql;
			insert into &dsTmpParms
			set Model = "NULL", NullModel = 1;
		quit;

		%BICSomeParm(&parms, somevar, parmname=&parmname);
	%end;

	%let dsParms = %BICNewDatasetName(parms);

	proc sql;
		create table &dsParms as
		select a.*, b.ModelRank, b.ModelProb, . as i
		from &dsTmpParms as a, &dsConvergedModels as b
		where a.Model = b.Model;
	quit;

	%let dsParms2Report = %BICNewDatasetName(parms2report);
	data &dsParms2Report;
		set &dsParms;
		if NullModel then &parmname = "&somevar";
	run;

	%let dsTmp = %BICNewDatasetName(tmp);
	proc sql;
		create table &dsTmp as
		select &parmname, N(distinct ClassVal0) as nClassVal0
		from &dsParms2Report
		group &parmname;
	quit;

	proc sql noprint;
		select max(nClassVal0) gt 1 into :anyclassval0
		from &dsTmp;
	quit;

	%if &anyclassval0 %then %do;
		proc sql noprint;
			select max(length(catx(" = ", &parmname, ClassVal0))) into :lmax
			from &dsParms2Report;
		quit;

		%let dsTmp = %BICNewDatasetName(tmp);
		proc sql;
			create table &dsTmp as
			select *, catx(" = ", &parmname, ClassVal0) as _&parmname length=&lmax
			from &dsParms2Report;
		quit;
		proc sql;
			alter table &dsTmp
			DROP &parmname;
		quit;
		proc datasets nolist;
			modify &dsTmp;
			rename _&parmname=&parmname;
		run;
		proc datasets nolist; delete &dsParms2Report; change &dsTmp=&dsParms2Report; quit;
	%end;

	proc report data=&dsParms2Report nofs style={rules=none cellspacing=0 leftmargin=.2in rightmargin=.2in} ls=256;
		col ModelRank Model ModelProb &parmname,(i Estimate StdErr OddsRatio OddsRatioLowerCL OddsRatioUpperCL);
		define ModelRank		/ group "Rank";
		define Model			/ group width=&lmodel;
		define ModelProb		/ group format=percent9.2;
		define &parmname	/ across;
		define Estimate		/ analysis "Estimate" format=&EstFmt;
		define StdErr			/ analysis "StdErr" format=&EstFmt;
		define OddsRatio		/ analysis "Odds Ratio" format=&orfmt;
		define OddsRatioLowerCL	/ analysis format=&orfmt;
		define OddsRatioUpperCL	/ analysis format=&orfmt;
		define i / display style={foreground=&colsepcolor background=&colsepcolor cellwidth=5pt font_size=1};

		%if %length(%superq(where)) > 0 %then %do;
			where &where;
		%end;
	run;
	proc datasets nolist; delete &dsParms2Report; quit;

	* Compute first model out;

	%let dsContents = %BICNewDatasetName(contents);
	proc contents data=&dsParms out=&dsContents (keep=name length) noprint; run;
	proc sql noprint;
		select length into :lvar
		from &dsContents
		where upcase(name) eq "&ucparmname";
	quit;

	proc sql noprint;
		select DISTINCT(&parmname) into :vars separated by ' '
		from &dsParms;
	quit;

	proc sql noprint;
		select DISTINCT(ModelRank) into :ModelRanks separated by ' '
		from &dsParms;
	quit;

	%let dsCompleteVarsModelsList = %BICNewDatasetName(tmp);
	%let nmodels	= %BICntokens(&ModelRanks);
	%let nvars		= %BICntokens(&vars);

	proc sql;
		create table &dsCompleteVarsModelsList as
		select &parmname, ModelRank
		from &dsParms
		where NullModel ne 1
		order by &parmname, ModelRank;
	quit;

	%let dsModelRanks = %BICNewDatasetName(tmp);

	data &dsModelRanks;
		length &parmname $ &lvar;
		%do v = 1 %to &nvars;
			%let var = %scan(&vars, &v, %str( ));
			do ModelRank = 1 to &nmodels;
				&parmname = "&var";
				output;
			end;
		%end;
	run;
	proc sort data=&dsModelRanks; by &parmname ModelRank; run;

	data &dsModelRanks;
		merge &dsModelRanks (in=in1) &dsCompleteVarsModelsList (in=in2);
		by &parmname ModelRank;
		if in1 and not in2;
	run;

	%let dsFirstModelOut	= %BICNewDatasetName(firstmodelout);

	proc sql;
		create table &dsFirstModelOut as
		select &parmname, min(ModelRank) as FirstModelOut label = "First Model Without"
		from &dsModelRanks
		group &parmname;
	quit;

	* Compute Posterior probability for each variable, as well as Mean, StdErr and OddsRatio;

	%let dsPostprob = %BICNewDatasetName(postprob);

	proc sql;
		create table &dsPostProb as
		select &parmname, ClassVal0 label="Class", sum(ModelProb) as PostProb format=percent9.2 label="Post Prob",
			min(ModelRank) as FirstModelIn label="First Model In",
			sum(ModelProb*Estimate) as PostMean format=&EstFmt label="Post Mean",
			sqrt(sum(ModelProb*(StdErr**2+Estimate**2))-(calculated PostMean)**2) as PostStdErr format=&EstFmt label="Post StdErr",
			(calculated PostMean)/(calculated PostProb) as CondPostMean format=&EstFmt label="[cond] Post Mean",
			sqrt(sum(ModelProb*(StdErr**2+Estimate**2))/(calculated PostProb)-(calculated CondPostMean)**2) as CondPostStdErr format=&EstFmt label="[cond] Post StdErr",
			. as i
		from &dsParms
		where not missing(&parmname)
		group by &parmname, ClassVal0;
	quit;

	* Now estimate Post ORs from the mixture of normal distributions;

	data &dsPostProb;
		set &dsPostProb;
		j = _N_;
	run;

	proc sql noprint;
		select max(j) into :jmax
		from &dsPostProb;
	quit;

	%let dsBuffer					= %BICNewDatasetName(buffer);
	%let dsCondPostMoments	= %BICNewDatasetName(condpostmoments);
	%let dsPostMoments			= %BICNewDatasetName(postmoments);
	%let dsThisParmEstimates	= %BICNewDatasetName(thisparmestimates);
	%let dsTotPostMoments		= %BICNewDatasetName(totpostmoments);

	%do j = 1 %to &jmax;
		proc sql;
			create table &dsThisParmEstimates as
			select b.ModelProb, b.Estimate, b.StdErr
			from &dsPostProb as a, &dsParms as b
			where a.j eq &j and a.&parmname eq b.&parmname and a.ClassVal0 eq b.ClassVal0;
		quit;

		%BICNormalMixtureQuantiles(out=&dsCondPostMoments, data=&dsThisParmEstimates, conditional=1, probs=&probs);
		%BICNormalMixtureQuantiles(out=&dsPostMoments, data=&dsThisParmEstimates, probs=&probs);

		proc sql;
			create table &dsBuffer as
			select
				exp(c.Med) as CondPostOddsRatio			label="[cond] Median Post Odds Ratio"			format=&EstFmt,
				exp(c.LCL) as LCLCondPostOddsRatio		label="[cond] &level100% LCL for OddsRatio" format=&EstFmt,
				exp(c.UCL) as UCLCondPostOddsRatio	label="[cond] &level100% UCL for OddsRatio" format=&EstFmt,
				exp(p.Med) as PostOddsRatio					label="Median Post Odds Ratio"						format=&EstFmt,
				exp(p.LCL) as LCLPostOddsRatio			label="&level100% LCL for OddsRatio" 			format=&EstFmt,
				exp(p.UCL) as UCLPostOddsRatio			label="&level100% UCL for OddsRatio" 			format=&EstFmt, 
				&j as j
			from &dsCondPostMoments as c, &dsPostMoments as p;
		quit;

		proc datasets nolist; delete &dsCondPostMoments &dsPostMoments &dsThisParmEstimates; quit;

		%if &j eq 1 %then %do;
			proc datasets nolist; change &dsBuffer=&dsTotPostMoments; quit;
		%end;
		%else %do;
			proc datasets nolist; append data=&dsBuffer base=&dsTotPostMoments; delete &dsBuffer; quit;
		%end;
	%end;

	proc sql;
		create table &dsBuffer as
		select p.*, m.CondPostOddsRatio, m.LCLCondPostOddsRatio, m.UCLCondPostOddsRatio, m.PostOddsRatio, m.LCLPostOddsRatio, m.UCLPostOddsRatio
		from &dsPostProb as p, &dsTotPostMoments as m
		where p.j eq m.j;
	quit;
	proc datasets nolist; delete &dsPostProb &dsTotPostMoments; change &dsBuffer=&dsPostProb; quit;


	data &dsPostProb;
		merge &dsPostProb (in=in1) &dsFirstModelOut;
		by &parmname;
		if in1;
	run;

	proc sort data=&dsPostProb; by descending PostProb FirstModelIn descending FirstModelOut &parmname ClassVal0; run;

	title 'Posterior Probability, Mean, StdErr and Odds Ratio for each variable';
	proc report data=&dsPostProb nofs style={rules=none cellspacing=0 leftmargin=.2in rightmargin=.2in};
		col &parmname PostProb FirstModelIn FirstModelOut 
			%if &anyclassval0 %then %do;
				ClassVal0
			%end;
			i
			("Posterior Parameters" PostMean PostStdErr PostOddsRatio LCLPostOddsRatio UCLPostOddsRatio) 
			i
			('Conditional [on being in the model] Posterior Parameters' CondPostMean CondPostStdErr CondPostOddsRatio LCLCondPostOddsRatio UCLCondPostOddsRatio);

		define &parmname			/ display;
		define PostProb				/ format=percent9.2;
		define FirstModelIn		/ analysis style={just=center};
		define FirstModelOut		/ analysis style={just=center};
		%if &anyclassval0 %then %do;
			define ClassVal0	/ display;
		%end;

		define PostMean				/ analysis format=&EstFmt;
		define PostStdErr			/ analysis format=&EstFmt;
		define PostOddsRatio			/ analysis format=&orfmt;
		define LCLPostOddsRatio		/ analysis format=&orfmt;
		define UCLPostOddsRatio		/ analysis format=&orfmt;

		define CondPostMean		/ analysis format=&EstFmt;
		define CondPostStdErr		/ analysis format=&EstFmt;
		define CondPostOddsRatio		/ analysis format=&orfmt;
		define LCLCondPostOddsRatio	/ analysis format=&orfmt;
		define UCLCondPostOddsRatio	/ analysis format=&orfmt;

		define i / display style={foreground=&colsepcolor background=&colsepcolor cellwidth=5pt font_size=1};
	run;
	title;

	proc datasets nolist;
		modify &dsModels;
		label
			p				= "p (number of parameters)"
			minus2logL	= "-2 log Likelihood"
			ModelRank	= "Rank"
			;
	run;

	* Add ModelProb to &dsDetails, just in case it was used in -where-;

	%let dsDetails = %BICNewDatasetName(details);

	proc sql;
		create table &dsDetails as
		select a.ModelRank, a.Model, a.BIC, a.minus2logL, a.p, b.ModelProb format=percent8.2,
		case
			when a.Converged = 1 then "Yes"
			else "No"
		end as Converged length=3
		from &dsModels as a, &dsConvergedModels as b
		where a.ModelRank = b.ModelRank;
	quit;

	title 'Details';
	proc print data=&dsDetails noobs label;
		var ModelRank Model Converged ModelProb BIC minus2logL p;
		%if %length(%superq(where)) %then %do;
			where &where;
		%end;
	run;
	title;

	proc datasets nolist; delete &dsCompleteVarsModelsList &dsContents &dsConvergedModels &dsDetails &dsFirstModelOut &dsModelRanks &dsModels &dsParms &dsParmsContents &dsPostprob &dsTmpConvergedModels &dsTmpParms; run;
%mend;


%macro BICCombination(combno, tokens, sep=%str( ));
	%local j jover2 ntokens t token;
	%let ntokens = %BICntokens(&tokens);

	%do t = 1 %to &ntokens;
		%let j = %eval((&combno-1)/(2**(&ntokens-&t)));
		%let jover2 = %eval(&j/2);
		%let j = %eval(2*&jover2 ^= &j);
		%if &j %then %do;
			%scan(&tokens, &t, &sep)
		%end;
	%end;
%mend;


%macro BICcommasep(lov);
   %sysfunc(tranwrd(%Qsysfunc(compbl(%sysfunc(strip(&lov)))), %str( ), %str(, )))
%mend;


%macro BICcommasepNoSpace(lov);
   %sysfunc(tranwrd(%Qsysfunc(compbl(%sysfunc(strip(&lov)))), %str( ), %str(,)))
%mend;


%macro BIClmax(tokens);
	%local ntokens token l res i;
	%let res = 0;
	%let ntokens = %BICntokens(&tokens);

	%do i = 1 %to %BICntokens(&tokens);
		%let token = %scan(&tokens, &i, %str( ));
		%let l = %length(&token);
		%if &l > &res %then %do;
			%let res = &l;
		%end;
	%end;

	%eval(&res)
%mend;


%macro BICOrdinalLogisticModelIsOk(outok, outmodel, model, force);
	%local dsForced dsForcedIsIn dsLov dsLovUniq dsUniqterms dsMinOrder;
	%local force0 i j lmax lmaxf lmaxi lov lovNoStar modelorder nforced nterms o ok orders t terms tmpmodel;

	%let lov = %sysfunc(tranwrd(%sysfunc(tranwrd(%sysfunc(compbl(&model)), %str(* ), %str(*))), %str( *), %str(*)));
	%let lovNoStar = %sysfunc(tranwrd(&lov, %str(*), %str( )));

	%let lmax		= %BIClmax(&lovNoStar);
	%let lmaxi		= %BIClmax(&lov);
	%let nterms	= %BICntokens(&lov);

	%let dsLov = %BICNewDatasetName(lov);

	data &dsLov;
		length term	$&lmaxi;
		length ucname	$&lmax;
		%do i = 1 %to &nterms;
			%let t = %scan(&lov, &i, %str( ));
			term = "&t";

			if index(term, "*") > 0 then do;
				order = 2;
				ucname = upcase(scan(term, 1));
				output;
				ucname = upcase(scan(term, 2));
				output;
			end;
			else do;
				order = 1;
				ucname = upcase(term);
				output;
			end;
		%end;
	run;

	%let dsMinOrder = %BICNewDatasetName(minorder);

	proc sql;
		create table &dsMinOrder as
		select ucname, min(order) as MinOrder
		from &dsLov
		group ucname;
	quit;

	proc sql noprint;
		select max(MinOrder) = 1 into :ok
		from &dsMinOrder;
	quit;

	%if %length(&force) and &ok %then %do;
		* Check that each forced term is in model;

		%let dsLovUniq = %BICNewDatasetName(lovUniq);

		proc sql;
			create table &dsLovUniq as
			select distinct(upcase(term)) as ucterm
			from &dsLov;
		quit;

		%let force0 = %sysfunc(tranwrd(%sysfunc(tranwrd(%sysfunc(compbl(&force)), %str(* ), %str(*))), %str( *), %str(*)));
		%let nforced = %BICntokens(&force0);
		%let lmaxf	= %BIClmax(&force0);
		%if &lmaxf < &lmaxi %then %let lmaxf = &lmaxi;

		%let dsForced = %BICNewDatasetName(force);

		data &dsForced (drop=term1 term2);
			length term $&lmaxf;
			%do i = 1 %to &nforced;
				%let t = %scan(&force0, &i, %str( ));
				term = upcase("&t");

				if index(term, "*") > 0 then do;
					term1 = scan(term, 1);
					term2 = scan(term, 2);
					ucterm = catx("*", term1, term2);
					output;
					ucterm = catx("*", term2, term1);
					output;
				end;
				else do;
					ucterm = term;
					output;
				end;
			%end;
		run;

		proc sort data=&dsForced; by ucterm; run;
		proc sort data=&dsLovUniq; by ucterm; run;

		data &dsForced;
			merge &dsForced (in=in1) &dsLovUniq (in=in2);
			by ucterm;
			if in1;
			inModel = in2;
		run;

		%let dsForcedIsIn = %BICNewDatasetName(forcedisin);

		proc sql;
			create table &dsForcedIsIn as
			select term, max(inModel) as inModel
			from &dsForced
			group term;
		quit;

		proc sql noprint;
			select min(inModel) = 1 into :ok
			from &dsForcedIsIn;
		quit;

		proc datasets nolist; delete &dsForced &dsForcedIsIn &dsLovUniq; run;
	%end;

	%if &ok %then %do;
		proc sql noprint;
			select max(order) into: modelorder
			from &dsLov;
		quit;

		%if &modelorder > 1 %then %do;
			%let dsUniqterms = %BICNewDatasetName(tmp);

			proc sql;
				create table &dsUniqterms as
				select order, term, N(term) as _dummy
				from &dsLov
				group order, term;
			quit;

			proc sql noprint;
				select order, term, N(term) into :orders separated by ' ', :terms separated by ' ', :nterms
				from &dsUniqterms;
			quit;

			%let j = 0;

			%do i = 1 %to &nterms;
				%let o = %scan(&orders, &i);
				%let t = %scan(&terms, &i, %str( ));
				%let tmpmodel = &tmpmodel &t;
			%end;

			%let &outmodel = &tmpmodel;

			proc datasets nolist; delete &dsUniqterms; run;
		%end;
		%else %do;
			%let &outmodel = &model;
		%end;
	%end;

	%let &outok = &ok;

	proc datasets nolist; delete &dsLov &dsMinOrder; run;
%mend;


%macro BICNewDatasetName(proposalname);
	%*Finds the first unused dataset named  *datasetname*, adding a leading underscore and a numeric suffix as large as necessary to make it unique!;
	%local i newdatasetname;
	%let proposalname=%sysfunc(compress(&proposalname));
	%let newdatasetname=_&proposalname;

	%do %while(%sysfunc(exist(&newdatasetname)));
		%let i = %eval(&i+1);
		%let newdatasetname=_&proposalname&i;
	%end;

	&newdatasetname
%mend;


%macro BICNormalMixtureQuantiles(out=, data=, mu=Estimate, sd=StdErr, wt=ModelProb, conditional=0, probEpsilon=1e-8, probs=0.025 0.50 0.975);
	%local cond d i inf LCL Med nprobs p p0 p0Degenerate pDegenerate ptarget sup totwt UCL x xnew;
	%let nprobs = 3;

	* Reserve output file name;
	data &out; stop; run;

	%if not &conditional %then %do;
		proc sql noprint;
			select sum(&wt*cdf('normal', 0, &mu, &sd)), 1-sum(&wt) into :p0, :pDegenerate
			from &data;
		quit;

		%let p0Degenerate = %sysevalf(&p0+&pDegenerate);
	%end;


	%do i = 1 %to &nprobs;
		%let p = %scan(&probs, &i, %str( ));
		%let ptarget = &p;
		%let cond = 1;

		%if not &conditional %then %do;
			%if %sysevalf(&p lt &p0, boolean) %then %do;
				%let ptarget = %sysevalf(&p/(1-&pDegenerate));
				proc sql noprint; select min(quantile('normal', &ptarget, &mu, &sd)), max(quantile('normal', &ptarget, &mu, &sd)) into :inf, :sup from &data; quit;
				%let ptarget = &p;
				%if %sysevalf(&sup gt 0, boolean) %then %let sup = 0;
			%end;
			%else %if %sysevalf(&p le &p0Degenerate, boolean) %then %do;
				%let x = 0;
				%let cond = 0;
			%end;
			%else %do;
				%let ptarget = %sysevalf((&p-&pDegenerate)/(1-&pDegenerate));
				proc sql noprint; select min(quantile('normal', &ptarget, &mu, &sd)), max(quantile('normal', &ptarget, &mu, &sd)) into :inf, :sup from &data; quit;
				%if %sysevalf(&inf lt 0, boolean) %then %let inf = 0;
				%let ptarget = %sysevalf(&p-&pDegenerate);
			%end;
		%end;
		%else %do;
			proc sql noprint; select min(quantile('normal', &p, &mu, &sd)), max(quantile('normal', &p, &mu, &sd)), sum(&wt) into :inf, :sup, :totwt from &data; quit;
			%let ptarget = %sysevalf(&p*&totwt);
		%end;
		

		%if &cond %then %let x = %sysevalf((&inf+&sup)/2);

		%do %while(&cond);
			proc sql noprint;
				select (sum(&wt*cdf('normal', &x, &mu, &sd))-&ptarget)/sum(&wt*pdf('normal', &x, &mu, &sd)) into :d
				from &data;
			quit;

			%let xnew = %sysevalf(&x-&d);

			%if %sysevalf(&xnew lt &inf, boolean) %then %do;
				%let sup = &x;
				%let d = %sysevalf((&x-&inf)/2);
				%let x = %sysevalf((&x+&inf)/2);
			%end;
			%else %if %sysevalf(&xnew gt &sup, boolean) %then %do;
				%let inf = &x;
				%let d = %sysevalf((&sup-&x)/2);
				%let x = %sysevalf((&x+&sup)/2);
			%end;
			%else %do;
				%if %sysevalf(&d gt 0) %then %let sup = &x;
				%else %let inf = &x;

				%let x = &xnew;
			%end;

			%let cond = %sysevalf(%sysfunc(abs(&d)) > &probEpsilon, boolean);
		%end;

		%if			&i eq 1	%then %let LCL = &x;
		%else %if	&i eq 2	%then %let Med = &x;
		%else %if	&i eq 3	%then %let UCL = &x;
	%end;

	data &out; Med = &Med; LCL = &LCL; UCL = &UCL; output; run;
%mend;


%macro BICntokens(list);
	%eval(1 + %length(%sysfunc(compbl(&list))) - %length(%sysfunc(compress(&list))))
%mend;


%macro BICSomeParm(dsParms, outparm, parmname=Parameter);
	%local dsTmp;
	%local outparmname;

	%let dsTmp = %BICNewDatasetName(tmp);
	proc sql;
		create table &dsTmp as
		select distinct(&parmname) as Parameter
		from &dsParms;
	quit;

	data &dsTmp;
		set &dsTmp;
		AnySpace = AnySpace(strip(Parameter));
	run;
	proc sort data=&dsTmp; by AnySpace; run;

	data &dsTmp;
		set &dsTmp;
		lineno = _N_;
	run;

	proc sql noprint; select Parameter into :outparmname from &dsTmp where lineno eq 1; quit;
	proc datasets nolist; delete &dsTmp; quit;

	%let &outparm = &outparmname;
%mend;
