   *               _\|/_
                   (o o)
    +----oOO-{_}-OOo----------------------------------------------------------------------------+
    :                                                                                                                       :
    :    BICSurvTimeDependent  (version 4.0.5 July 2011)                                        :
    :                                                                                                                      :
    :    Bayesian Information Criterion for Model Selection in Survival Analysis    :
    :    with Time-Dependent covariates                                                                :
    :                                                                                                                    :
    +--------------------------------------------------------------------------------------------;


/* ========================================================
	Limitations:
	-------------
	- interaction terms of order > 2 are not allowed 
	- interaction terms involving class variables are not allowed 

	Change log
	----------
    Version 4.0 (February 2011)
		Earlier versions did not take into account the multiple categories in independent variables in the number of parameters in model:
		therefore, if the independent variables included a categorical variable with more than two categories, the value of the BIC and hence 
		model probabilities were slightly off-target. 
*/;


%macro BICSurvTimeDependent(outModels=, outParms=, data=, time0=, time1=, cens=, indep=, force=, ties=exact, level=0.95);
	%local dsAllParameterEstimates dsBICData dsBuffer dsCensoredSummary dsContents dsContentsContents dsConvergenceStatus dsFitStatistics dsModel dsModels dsParameterEstimates;
	%local dsOrder2 dsOrder2a dsOrder2b dsVarsOrder0 dsVarsOrder dsxterms dsxvars;

	%local alpha anylabel anyvarNotFound bicphregmodel bicinternterms bicinterntermsinmodel bicsafeprefix classvars converged datalxvar definedMinus2LogLNULL fullmodel HigherOrder indepNoSpace it itm;
	%local lindep lmodel lxterms m mindep minus2logL minus2logLNULL model modelok mxterms nClassvars nClassvarsInterns nEvents niternterms nmodels notfound nterms order1vars order2terms;
	%local p parmname pNull strmodel t totnEvents v x xtermsNoSpace ;

	%let indepNoSpace = %sysfunc(compbl(%sysfunc(translate(&indep &force, %str( ), %str(*)))));

	%let lindep		= %BIClmax(&indepNoSpace);
	%let mindep	= %BICntokens(&indepNoSpace);
	%let definedMinus2LogLNULL = 0;
	%let pNull = 0;

	%let dsBuffer	= %BICNewDatasetName(buffer);
	%let dsxvars		= %BICNewDatasetName(xvars);

	%if &sysver >= 9.2 %then %let parmname = Parameter;
	%else %let parmname = Variable;

	%if %length(%superq(outModels)) eq 0 %then %do;
		%put ERROR: outModels= argument must be defined;
	%end;
	%if %length(%superq(outParms)) eq 0 %then %do;
		%put ERROR: outParms= argument must be defined;
	%end;
	%if %length(%superq(data)) eq 0 %then %do;
		%put ERROR: data= argument must be defined;
	%end;
	%if %length(%superq(time0)) eq 0 or %length(%superq(time1)) eq 0  %then %do;
		%put ERROR: Both time0= and time1= arguments must be defined;
	%end;
	%if %length(%superq(cens)) eq 0 %then %do;
		%put ERROR: cens= argument must be defined;
	%end;
	%if %length(%superq(indep)) eq 0 %then %do;
		%put ERROR: indep= argument must be defined;
	%end;

	data &dsxvars;
		length name $&lindep;
		%do v = 1 %to &mindep;
			%let x = %scan(&indepNoSpace, &v);
			name = "&x";
			ucname = upcase(name);
			output;
		%end;
	run;

	%let dsContents = %BICNewDatasetName(contents);

	proc contents data=&data out=&dsContents (keep=name format length varnum type) noprint; run;
	data &dsContents (drop=name);
		set &dsContents;
		ucname = upcase(name);
		IsFactor = not missing(format) or type eq 2;
	run;

	%let dsContentsContents = %BICNewDatasetName(contents);

	proc contents data=&dsContents out=&dsContentsContents (keep=name length) noprint; run;

	proc sql noprint;
		select length into :datalxvar
		from &dsContentsContents
		where upcase(name) eq "UCNAME";
	quit;

	proc sort data=&dsContents;		by ucname; run;
	proc sort data=&dsxvars;			by ucname; run;

	* Merge data sets with varnames;

	proc sql;
		create table &dsBuffer as
		select a.*, b.IsFactor, not missing(b.IsFactor) as inData, b.varnum
		from &dsxvars as a
		left join &dsContents as b
		on a.ucname = b.ucname;
	quit;
	proc datasets nolist; delete &dsxvars; change &dsBuffer=&dsxvars; quit;

	proc sql noprint;
		select min(inData) = 0 into :anyvarNotFound
		from &dsxvars;
	quit;

	%if &anyvarNotFound = 1 %then %do;
		proc sql noprint;
			select name into :notfound separated by ','
			from &dsxvars
			where inData = 0;
		quit;

		%put ERROR: variable(s) [&notfound] not found in data set &data;
		%goto skip0;
	%end;

	proc sort data=&dsxvars; by varnum; run;
	data &dsxvars;
		set &dsxvars;
		by varnum;
		if first.varnum;
	run;

	proc sql noprint;
		select name into :order1vars separated by ' '
		from &dsxvars;
	quit;

	* Make sure that no interaction term of order > 2 was given in model;

	%let xtermsNoSpace = %sysfunc(tranwrd(%sysfunc(tranwrd(%sysfunc(compbl(&indep &force)),%str( *), %str(*))), %str(* ), %str(*)));

	%let lxterms	= %BIClmax(&xtermsNoSpace);
	%let mxterms	= %BICntokens(&xtermsNoSpace);

	%let dsxterms = %BICNewDatasetName(xterms0);

	data &dsxterms;
		length name $&lxterms;
		%do v = 1 %to &mxterms;
			%let x = %scan(&xtermsNoSpace, &v, %str( ));
			name = "&x";
			ucname = upcase(name);
			order = 1 + length(ucname) - length(compress(ucname,"*"));
			output;
		%end;
	run;

	%let dsVarsOrder0 = %BICNewDatasetName(VarsOrder0);

	data &dsVarsOrder0 (drop=_star _ucname);
		set &dsxterms (drop=name);
		if order = 2 then do;
			_ucname = ucname;
			_star = index(ucname, "*");
			ucname = substr(_ucname, 1, _star - 1);
			output;
			ucname = substr(_ucname, _star + 1);
			output;
		end;
		else output;
	run;

	%let dsVarsOrder = %BICNewDatasetName(VarsOrder);

	proc sql;
		create table &dsVarsOrder as
		select ucname, max(order) as order
		from &dsVarsOrder0
		group ucname;
	quit;

	* Crash if any interaction term involves categorical variables;

	proc sql noprint;
		select a.name, N(a.name) into :classvars separated by ',', :nClassvarsInterns
		from &dsxvars as a, &dsVarsOrder as b
		where a.ucname = b.ucname and a.IsFactor and b.order > 1;
	quit;

	%if &nClassvarsInterns %then %do;
		%put ERROR: class variable(s) [&classvars] are are not allowed in interaction terms in the current version of BICSurvTimeDependent;
		%goto skip0;
	%end;

	* Count number of class variables;

	proc sql noprint;
		select name, N(name) into :classvars separated by ' ', :nClassvars
		from &dsxvars
		where IsFactor;
	quit;

	* Crash if any order > 2;

	proc sql noprint;
		select max(order) into :HigherOrder
		from &dsVarsOrder;
	quit;

	%if &HigherOrder > 2 %then %do;
		%put ERROR: Terms of order > 2 not allowed in current version. Sorry.;
		%goto skip0;
	%end;

	%if &HigherOrder > 1 %then %do;
		%BICDefineSafeVarPrefix(bicsafeprefix, &data);

		%let dsOrder2 = %BICNewDatasetName(order2);

		proc sql;
			create table &dsOrder2 as
			select name, ucname
			from &dsxterms
			where order = 2;
		quit;

		data &dsOrder2;
			set &dsOrder2;
			ucname1 = scan(ucname, 1);
			ucname2 = scan(ucname, 2);
		run;

		%let dsOrder2a = %BICNewDatasetName(order2);

		proc sql;
			create table &dsOrder2a as
			select a.*, b.varnum as varnum1
			from &dsOrder2 as a, &dsxvars as b
			where a.ucname1 = b.ucname;
		quit;

		%let dsOrder2b = %BICNewDatasetName(order2);

		proc sql;
			create table &dsOrder2b as
			select a.*, b.varnum as varnum2
			from &dsOrder2a as a, &dsxvars as b
			where a.ucname2 = b.ucname;
		quit;

		data &dsOrder2b;
			set &dsOrder2b;
			if varnum1 > varnum2 then ucname = catx("*", ucname2, ucname1);
		run;

		proc sort data=&dsOrder2b; by ucname; run;
		
		data &dsorder2b;
			set &dsOrder2b;
			by ucname;
			if first.ucname;
		run;

		proc sql noprint;
			select name into :order2terms separated by ' '
			from &dsOrder2b;
		quit;

		proc datasets nolist; delete &dsOrder2 &dsOrder2a &dsOrder2b; run;
	%end;

	%let fullmodel = &order1vars &order2terms;

	* Model is now certified, let-s start the real work!;

	%let nterms	= %BICntokens(&fullmodel);
	%let nmodels	= %eval(2**&nterms);
	%let alpha		= %sysevalf(1-&level);

	%let dsAllParameterEstimates	= %BICNewDatasetName(AllParms);
	%let dsBICData						= %BICNewDatasetName(BICData);
	%let dsCensoredSummary			= %BICNewDatasetName(CensoredSummary);
	%let dsConvergenceStatus		= %BICNewDatasetName(ConvergenceStatus);
	%let dsFitStatistics				= %BICNewDatasetName(FitStatistics);
	%let dsModel							= %BICNewDatasetName(model);
	%let dsModels						= %BICNewDatasetName(models);
	%let dsParameterEstimates		= %BICNewDatasetName(ParameterEstimates);

	proc sql;
		create table &dsBICData as
		select *
		from &data
		where CMiss(%BICcommasep(&time0 &time1 &cens &order1vars)) = 0;
	quit;

	proc sql noprint;
		select sum(&cens) into :totnEvents
		from &dsBICData;
	quit;

	%if &totnEvents = 0 %then %do;
		%put ERROR: no events left in BIC with indep vars &order1vars;
		%goto skip;
	%end;

	%let lmodel	= %length(&fullmodel);
	
	* ~ * ~ * ~ * ~ * ~ * ~ *;

	%do m = &nmodels %to 1 %by -1;
		%let model = %BICCombination(&m, &fullmodel);

		%if %length(&model) = 0 %then %do;
			%let bicphregmodel =;
			%let bicinternterms =;
			%let strmodel=NULL;
			%let p = &pNull;

			%if %length(&force) > 0 %then %do;
				%let modelok = 0;
			%end;
			%else %do;
				%let modelok = 1;
			%end;
		%end;
		%else %do;
			%let strmodel = %BICcommasepNoSpace(&model);
			%let p = %sysevalf(&pNull+1);
			%BICModelIsOk(modelok, bicphregmodel, bicinternterms, bicinterntermsinmodel, &model, &bicsafeprefix, &force);
		%end;


		%if &modelok = 1 %then %do;
			%let minus2logL = -9999;
			%let converged = -9;

			%if &p > &pNull %then %do;
				proc phreg data=&dsBICData;
					%if &nClassvars gt 0 %then %do;
						class &classvars;
					%end;
					model (&time0, &time1) * &cens(0) = &bicphregmodel / risklimits ties=&ties alpha=&alpha;

					%if %length(&bicinternterms) %then %do;
						%let niternterms = %BICntokens(&bicinternterms);
						
						%do t = 1 %to &niternterms;
							%let it		= %scan(&bicinternterms, &t, %str( ));
							%let itm	= %scan(&bicinterntermsinmodel, &t, %str( ));
							&itm = &it;
						%end;
					%end;

					ods output CensoredSummary=&dsCensoredSummary FitStatistics=&dsFitStatistics ParameterEstimates=&dsParameterEstimates ConvergenceStatus=&dsConvergenceStatus;
				run;

				proc sql noprint;
					select N(Estimate) into :p
					from &dsParameterEstimates;
				quit;

				proc sql noprint;
					select event into :nEvents
					from &dsCensoredSummary;
				quit;

				proc sql noprint;
					select WithCovariates into :minus2logL
					from &dsFitStatistics
					where Criterion eq "-2 LOG L";
				quit;

				%if &definedMinus2LogLNULL = 0 %then %do;
					proc sql noprint;
						select WithoutCovariates into :minus2logLNULL
						from &dsFitStatistics
						where Criterion eq "-2 LOG L";
					quit;
					%let definedMinus2LogLNULL = 1;
				%end;

				proc sql noprint;
					select status into :converged
					from &dsConvergenceStatus;
				quit;

				proc contents data=&dsParameterEstimates out=&dsBuffer (keep=name) noprint; run;
				proc sql noprint; select N(name) into :anylabel from &dsBuffer where upcase(name) eq "LABEL"; quit;
				proc datasets nolist; delete &dsBuffer; quit;

				data &dsParameterEstimates;
					length model $ &lmodel;
					set &dsParameterEstimates (keep=&parmname Estimate StdErr HazardRatio HRLowerCL HRUpperCL
						%if &anylabel %then %do;
							label
						%end;
						);
					Model = "&strmodel";

					%if %length(&bicinternterms) %then %do;			
						%do t = 1 %to &niternterms;
							%let it		= %scan(&bicinternterms, &t, %str( ));
							%let itm	= %scan(&bicinterntermsinmodel, &t, %str( ));
							%if &t > 1 %then %do;
								else
							%end;
							if &parmname = "&itm" then &parmname = "&it";
						%end;
					%end;
				run;

				proc datasets nolist; delete &dsConvergenceStatus &dsFitStatistics; run;
			%end;
			%else %do;
				* p = &pNull;
				%let minus2logL	= &minus2logLNULL;
				%let converged	= 0;
			%end;

			data &dsModel;
				length Model $ &lmodel;
				Model = "&strmodel";
				Converged = (&converged = 0);
				BIC = &minus2logL + &p * log(&nEvents);
				minus2logL = &minus2logL;
				p = &p;
				nEvents = &nEvents;
			run;

			%if %sysfunc(exist(&dsAllParameterEstimates)) = 0 %then %do;
				proc datasets nolist; change &dsParameterEstimates=&dsAllParameterEstimates &dsModel=&dsModels; run;
			%end;
			%else %if &p > &pNull %then %do;
				proc sql;
					create table &dsBuffer as
					select * from &dsParameterEstimates
					outer union corresponding
					select * from &dsAllParameterEstimates;
				quit;
				proc datasets nolist; delete &dsParameterEstimates &dsAllParameterEstimates; change &dsBuffer=&dsAllParameterEstimates; quit;

				proc sql;
					create table &dsBuffer as
					select * from &dsModel
					outer union corresponding
					select * from &dsModels;
				quit;
				proc datasets nolist; delete &dsModel &dsModels; change &dsBuffer=&dsModels; quit;
			%end;
			%else %do;
				proc sql;
					create table &dsBuffer as
					select * from &dsModel
					outer union corresponding
					select * from &dsModels;
				quit;
				proc datasets nolist; delete &dsModel &dsModels; change &dsBuffer=&dsModels; quit;
			%end;
		%end;
	%end;


	%if %sysfunc(exist(&outModels)) > 0 %then %do;
		proc datasets nolist; delete &outModels; run;
	%end;

	%if %sysfunc(exist(&outParms)) > 0 %then %do;
		proc datasets nolist; delete &outParms; run;
	%end;

	proc sql;
		create table &outModels as
		select *, p eq &pNull as IsNullModel
		from &dsModels;
	quit;
	proc datasets nolist; delete &dsModels; quit;

	%if &nClassvars gt 0 %then %do;
		proc sql;
			create table &outParms as
			select *, coalesce(label, &parmname) as tmp&parmname
			from &dsAllParameterEstimates;
		quit;
		proc datasets nolist; delete &dsAllParameterEstimates; quit;
		proc sql; alter table &outParms drop &parmname; quit;
		proc datasets nolist; modify &outParms; rename tmp&parmname=&parmname; quit;
	%end;
	%else %do;
		proc datasets nolist; change &dsAllParameterEstimates=&outParms; run;
	%end;


	%skip:
	proc datasets nolist; delete &dsBICData; run;

	%skip0:
	proc datasets nolist; delete &dsContents &dsContentsContents &dsVarsOrder0 &dsVarsOrder &dsxvars &dsxterms; run;
%mend;


%macro BICSurvTimeDependentReport(models=, parms=, where=round(ModelProb,.0001) gt 0.01, EstFmt=5.2, colsepcolor=#FFE666);
	%local dsBuffer dsCondPostMoments dsConvergedModels dsDetails dsFirstModelOut dsModels;
	%local dsParms dsParms2report dsParmsContents dsPostMoments dsPostprob dsThisParmEstimates dsTmpConvergedModels dsTmpParms dsTotPostMoments;
	%local j jmax level level0 level1 level100 lmodel NullModelIsIn parmname probs r rank someparm v var;

	/*
		use with where=									(undefined) to report each model 
		use with where=ModelRank le 15				(e.g.) to report only the 15 first models 
	*/;

	%if %length(%superq(models)) eq 0 %then %do;
		%put ERROR: models= argument must be defined;
	%end;
	%if %length(%superq(parms)) eq 0 %then %do;
		%put ERROR: parms= argument must be defined;
	%end;

	%if &sysver >= 9.2 %then %let parmname = Parameter;
	%else %let parmname = Variable;
	%let ucparmname=%upcase(&parmname); 

	%let dsParmsContents = %BICNewDatasetName(ParmsContents);
	proc contents data=&Parms out=&dsParmsContents (keep=name label) noprint; run;

	proc sql noprint;
		select input(scan(label, 1, " "), percent.) into :level
		from &dsParmsContents
		where upcase(name) eq "HRLOWERCL";
	quit;

	%let level0		= %sysevalf((1-&level)/2);
	%let level1		= %sysevalf((1+&level)/2);
	%let probs		= &level0 0.5 &level1;
	%let level100 = %sysevalf(100*&level);

	proc sql noprint;
		select max(IsNullModel) eq 1 into :NullModelIsIn
		from &Models;
	quit;

	%let dsModels = %BICNewDatasetName(models);

	data &dsModels;
		set &Models;
		if not Converged then do;
			minus2logL = .;
			BIC = .;
		end;
	run;
	proc sort data=&dsModels; by descending Converged BIC p; run;

	data &dsModels;
		set &dsModels;
		if Converged then ModelRank = _N_;
	run;

	%let dsTmpConvergedModels = %BICNewDatasetName(converged);

	proc sql;
		create table &dsTmpConvergedModels as
		select *, BIC - min(BIC) as BIC0,  exp(-(calculated BIC0)/2) as _p
		from &dsModels
		where Converged = 1;
	quit;

	%let dsConvergedModels = %BICNewDatasetName(converged);

	proc sql;
		create table &dsConvergedModels as
		select *, _p /sum(_p) as ModelProb
		from &dsTmpConvergedModels;
	quit;

	%let dsTmpParms = %BICNewDatasetName(tmpparms);

	proc sql;
		create table &dsTmpParms as
		select *, 0 as NullModel
		from &Parms;
	quit;;

	%if &NullModelIsIn %then %do;
		* NULL model is in: add it to dsTmpParms;

		proc sql noprint;
			select max(length(model)) into :lmodel
			from &Parms;
		quit;

		%if &lmodel < 4 %then %let lmodel = 4;

		proc sql;
			insert into &dsTmpParms
			set Model = "NULL", NullModel = 1;
		quit;
	%end;

	%let dsParms = %BICNewDatasetName(parms);

	proc sql;
		create table &dsParms as
		select a.*, b.ModelRank, b.ModelProb, . as i
		from &dsTmpParms as a, &dsConvergedModels as b
		where a.Model = b.Model;
	quit;

	%BICSomeParm(&parms, someparm, parmname=&parmname);
	%let dsParms2report = %BICNewDatasetName(parms2report);
	data &dsParms2Report;
		set &dsParms;
		if NullModel then &parmname = "&someparm";
	run;

	proc report data=&dsParms2report nofs style={rules=none cellspacing=0 leftmargin=.2in rightmargin=.2in};
		col ModelRank Model ModelProb &parmname,(i Estimate StdErr HazardRatio HRLowerCL HRUpperCL);
		define ModelRank		/ group "Rank";
		define Model			/ group;
		define ModelProb		/ group format=percent9.2;
		define &parmname	/ across;
		define Estimate		/ analysis "Estimate" format=&EstFmt;
		define StdErr			/ analysis "StdErr";
		define HazardRatio	/ analysis "Hazard Ratio";
		define HRLowerCL	/ analysis;
		define HRUpperCL	/ analysis;
		define i / display style={foreground=&colsepcolor background=&colsepcolor cellwidth=5pt font_size=1};

		%if %length(%superq(where)) > 0 %then %do;
			where &where;
		%end;
	run;
	proc datasets nolist; delete &dsParms2report; quit;

	* Compute first model out;
	%let dsFirstModelOut	= %BICNewDatasetName(firstmodelout);
	%BICFirstModelOut(models=&dsModels, parms=&parms, out=&dsFirstModelOut, parmname=&parmname);

	* Compute Posterior probability for each variable, as well as Mean and StdErr and Hazard Ratio;

	%let dsPostprob = %BICNewDatasetName(postprob);

	proc sql;
		create table &dsPostProb as
		select &parmname, sum(ModelProb) as PostProb format=percent9.2 label="Post Prob",
			min(ModelRank) as FirstModelIn label="First Model In",
			sum(ModelProb*Estimate) as PostMean format=&EstFmt label="Post Mean",
			sqrt(sum(ModelProb*(StdErr**2+Estimate**2))-(calculated PostMean)**2) as PostStdErr format=&EstFmt label="Post StdErr",
			(calculated PostMean)/(calculated PostProb) as CondPostMean format=&EstFmt label="[cond] Post Mean",
			sqrt(sum(ModelProb*(StdErr**2+Estimate**2))/(calculated PostProb)-(calculated CondPostMean)**2) as CondPostStdErr format=&EstFmt label="[cond] Post StdErr",
			. as i
		from &dsParms
		where not missing(&parmname)
		group by &parmname;
	quit;

	* Compute Posterior Hazard Ratio for each variable [parameter];

	data &dsPostProb;
		set &dsPostProb;
		j = _N_;
	run;

	proc sql noprint;
		select max(j) into :jmax
		from &dsPostProb;
	quit;

	%let dsBuffer					= %BICNewDatasetName(buffer);
	%let dsCondPostMoments		= %BICNewDatasetName(condpostmoments);
	%let dsPostMoments			= %BICNewDatasetName(postmoments);
	%let dsThisParmEstimates	= %BICNewDatasetName(thisparmestimates);
	%let dsTotPostMoments		= %BICNewDatasetName(totpostmoments);

	%do j = 1 %to &jmax;
		proc sql;
			create table &dsThisParmEstimates as
			select b.ModelProb, b.Estimate, b.StdErr
			from &dsPostProb as a, &dsParms as b
			where a.j eq &j and a.&parmname eq b.&parmname;
		quit;

		%BICNormalMixtureQuantiles(out=&dsCondPostMoments, data=&dsThisParmEstimates, conditional=1, probs=&probs);
		%BICNormalMixtureQuantiles(out=&dsPostMoments, data=&dsThisParmEstimates, probs=&probs);

		proc sql;
			create table &dsBuffer as
			select &j as j,
				exp(c.Med) as CondPostHR, exp(c.LCL) as LCLCondPostHR, exp(c.UCL) as UCLCondPostHR,
				exp(p.Med) as PostHR, exp(p.LCL) as LCLPostHR, exp(p.UCL) as UCLPostHR
			from &dsCondPostMoments as c, &dsPostMoments as p;
		quit;

		proc datasets nolist; delete &dsCondPostMoments &dsPostMoments &dsThisParmEstimates; quit;

		%if &j eq 1 %then %do;
			proc datasets nolist; change &dsBuffer=&dsTotPostMoments; quit;
		%end;
		%else %do;
			proc datasets nolist; append data=&dsBuffer base=&dsTotPostMoments; delete &dsBuffer; quit;
		%end;
	%end;

	proc sql;
		create table &dsBuffer as
		select p.*, 
			m.CondPostHR			label="[cond] Median Post Hazard Ratio"				format=&EstFmt,
			m.LCLCondPostHR	label="[cond] &level100% LCL for Hazard Ratio" 	format=&EstFmt,
			m.UCLCondPostHR	label="[cond] &level100% UCL for Hazard Ratio" format=&EstFmt,
			m.PostHR				label="Median Post Hazard Ratio"						format=&EstFmt,
			m.LCLPostHR			label="&level100% LCL for Hazard Ratio"			format=&EstFmt,
			m.UCLPostHR			label="&level100% UCL for Hazard Ratio" 			format=&EstFmt
		from &dsPostProb as p, &dsTotPostMoments as m
		where p.j eq m.j;
	quit;
	proc datasets nolist; delete &dsPostProb &dsTotPostMoments; change &dsBuffer=&dsPostProb; quit;

	data &dsPostProb;
		merge &dsPostProb (in=in1) &dsFirstModelOut;
		by &parmname;
		if in1;
	run;

	proc sort data=&dsPostProb; by descending PostProb FirstModelIn descending FirstModelOut &parmname; run;

	title 'Posterior Probability, Mean, StdErr and Hazard Ratio for each variable';
	proc report data=&dsPostProb nofs style={rules=none cellspacing=0 leftmargin=.2in rightmargin=.2in};
		col &parmname PostProb FirstModelIn FirstModelOut i
			("Posterior Parameters" PostMean PostStdErr PostHR LCLPostHR UCLPostHR) 
			i
			('Conditional [on being in the model] Posterior Parameters' CondPostMean CondPostStdErr CondPostHR LCLCondPostHR UCLCondPostHR);

		define &parmname			/ display;
		define PostProb				/ format=percent9.2;
		define FirstModelIn		/ analysis style={just=center};
		define FirstModelOut		/ analysis style={just=center};

		define PostMean				/ analysis format=&EstFmt;
		define PostStdErr			/ analysis format=&EstFmt;
		define PostHR					/ analysis format=&EstFmt;
		define LCLPostHR			/ analysis format=&EstFmt;
		define UCLPostHR			/ analysis format=&EstFmt;

		define CondPostMean		/ analysis format=&EstFmt;
		define CondPostStdErr		/ analysis format=&EstFmt;
		define CondPostHR			/ analysis format=&EstFmt;
		define LCLCondPostHR		/ analysis format=&EstFmt;
		define UCLCondPostHR		/ analysis format=&EstFmt;

		define i / display style={foreground=&colsepcolor background=&colsepcolor cellwidth=5pt font_size=1};
	run;
	title;

	proc datasets nolist;
		modify &dsModels;
		label
			p				= "p (number of parameters)"
			minus2logL	= "-2 log Likelihood"
			ModelRank	= "Rank"
			nEvents		= "number of events"
			;
	run;

	* Add ModelProb to &dsDetails, just in case it was used in -where-;

	%let dsDetails = %BICNewDatasetName(details);

	proc sql;
		create table &dsDetails as
		select a.ModelRank, a.Model, a.BIC, a.minus2logL, a.p, a.nEvents, b.ModelProb format=percent8.2,
		case
			when a.Converged = 1 then "Yes"
			else "No"
		end as Converged length=3
		from &dsModels as a, &dsConvergedModels as b
		where a.ModelRank = b.ModelRank;
	quit;

	title 'Details';
	proc print data=&dsDetails noobs label;
		var ModelRank Model Converged ModelProb BIC minus2logL p nEvents;
		%if %length(%superq(where)) %then %do;
			where &where;
		%end;
	run;
	title;

	proc datasets nolist; delete &dsConvergedModels &dsDetails &dsFirstModelOut &dsModels &dsParms &dsParmsContents &dsPostprob &dsTmpConvergedModels &dsTmpParms; run;
%mend;


%macro BICCombination(combno, tokens, sep=%str( ));
	%local j jover2 ntokens t token;
	%let ntokens = %BICntokens(&tokens);

	%do t = 1 %to &ntokens;
		%let j = %eval((&combno-1)/(2**(&ntokens-&t)));
		%let jover2 = %eval(&j/2);
		%let j = %eval(2*&jover2 ^= &j);
		%if &j %then %do;
			%scan(&tokens, &t, &sep)
		%end;
	%end;
%mend;


%macro BICcommasep(lov);
   %sysfunc(tranwrd(%Qsysfunc(compbl(%sysfunc(strip(&lov)))), %str( ), %str(, )))
%mend;


%macro BICcommasepNoSpace(lov);
   %sysfunc(tranwrd(%Qsysfunc(compbl(%sysfunc(strip(&lov)))), %str( ), %str(,)))
%mend;


%macro BICDefineSafeVarPrefix(outprefix, datasets, errorLength=11);
	%local dsBuffer dsContents dsContents0 dsTmp dsUnavailablePrefixes;
	%local d nds nvarnames tmpds tmpprefix ;
	%local i j k;

	%let dsBuffer		= %BICNewDatasetName(buffer);
	%let dsContents		= %BICNewDatasetName(contents);
	%let dsContents0	= %BICNewDatasetName(contents0);

	%let nds = %BICntokens(&datasets);

	%do d = 1 %to &nds;
		%let tmpds = %scan(&datasets, &d, %str( ));

		proc contents data=&tmpds out=&dsContents (keep=name) noprint; run;

		%if &d = 1 %then %do;
			proc datasets nolist; change &dsContents=&dsContents0; run;
		%end;
		%else %do;
			proc sql;
				create table &dsBuffer as
				select * from &dsContents
				outer union corresponding
				select * from &dsContents0;
			quit;
			proc datasets nolist; delete &dsContents &dsContents0; change &dsBuffer=&dsContents0; quit;
		%end;
	%end;

	proc sql;
		create table &dsContents as
		select distinct(name)
		from &dsContents0;
	quit;

	proc sql noprint;
		select N(name) into :nvarnames
		from &dsContents;
	quit;

	* find the maximum length for safe prefix;

	%let j = %eval(1 + %sysfunc(floor(%sysevalf(%sysfunc(log(&nvarnames))/%sysfunc(log(27))))));

	%let dsTmp = %BICNewDatasetName(tmp);

	data &dsTmp;
		%do i = 1 %to &j;
			a&i = 0;
		%end;
		output;
	run;

	data &dsTmp (keep=l varp);
		set &dsTmp;
		length varp $ &j;

		array a{*} a1-a&j;

		do l = 1 to &j;
			kmax = 27**l;
			do k = 1 to kmax;
				varp = "";
				do j = 1 to l;
					a{j} = mod(floor((k-1)/(27**(j-1))), 27) + 1;
					varp = cats(varp, substr("_abcdefghijklmnopqrstuvwxyz", a{j}, 1));
				end;
				output;
			end;
		end;
	run;

	* List prefixes already present in at least one variable name;

	%let dsUnavailablePrefixes = %BICNewDatasetName(unavailablepref);

	data &dsUnavailablePrefixes (drop=name l);
		set &dsContents;
		length varp $ &j;

		do l = 1 to &j;
			varp = substr(name, 1, l);
			output;
		end;
	run;
	proc sort data=&dsUnavailablePrefixes; by varp; run;

	data &dsUnavailablePrefixes;
		set &dsUnavailablePrefixes;
		by varp;
		if first.varp;
	run;

	proc sort data=&dsTmp; by varp; run;

	data &dsTmp;
		merge &dsTmp (in=in1) &dsUnavailablePrefixes (in=in2);
		by varp;
		if in1 and not in2;
	run;
	proc sort data=&dsTmp; by l varp; run;

	data &dsTmp; set &dsTmp (obs=1); run;

	proc sql noprint;
		select varp, l into :&outprefix, :lprefix
		from &dsTmp;
	quit;

	%if &lprefix >= &errorLength %then %do;
		%let lprefix = %sysfunc(compress(&lprefix));
		%put ERROR: safe prefix is of length (&lprefix) greater or equal than that prescribed by errorLength (&errorLength);
	%end;

	proc datasets nolist; delete &dsContents0 &dsContents &dsTmp &dsUnavailablePrefixes; run;
%mend;


%macro BICFirstModelOut(models=, parms=, out=, parmname=Parameter);
	%local dsParmsIn dsParmsList dsParmsXModelRankList dsTmp;

	* Input file *models* must include variables: Model, ModelRank;
	* Input file *parms* must include variables: &parmname, Model;

	* Reserve output file name;
	data &out; stop; run;

	%let dsParmsList = %BICNewDatasetName(parmslist);
	proc sql;
		create table &dsParmsList as
		select distinct &parmname
		from &parms;
	quit;

	%let dsParmsXModelRankList = %BICNewDatasetName(parmsXmodelrank);
	proc sql;
		create table &dsParmsXModelRankList as
		select p.&parmname, m.Model, m.ModelRank
		from &dsParmsList as p, &models as m;
	quit;

	%let dsParmsIn = %BICNewDatasetName(parmsin);
	proc sql;
		create table &dsParmsIn as
		select p.&parmname, m.ModelRank
		from &parms as p, &models as m
		where upcase(p.model) eq upcase(m.model);
	quit;

	%let dsTmp = %BICNewDatasetName(tmp);
	proc sql;
		create table &dsTmp as
		select &parmname, min(ModelRank) as FirstModelOut
		from
			(select l.&parmname, l.ModelRank, not missing(p.ModelRank) as ParmIn
			from &dsParmsXModelRankList as l
			left join &dsParmsIn as p
			on l.&parmname eq p.&parmname and l.ModelRank eq p.ModelRank)
		where ParmIn eq 0
		group &parmname;

		create table &out as
		select p.&parmname, t.FirstModelOut label = "First Model Without"
		from &dsParmsList as p
		left join &dsTmp as t
		on p.&parmname eq t.&parmname;
	quit;

	proc datasets nolist; delete &dsParmsIn &dsParmsList &dsParmsXModelRankList &dsTmp; quit;
%mend;


%macro BIClmax(tokens);
	%local ntokens token l res i;
	%let res = 0;
	%let ntokens = %BICntokens(&tokens);

	%do i = 1 %to %BICntokens(&tokens);
		%let token = %scan(&tokens, &i, %str( ));
		%let l = %length(&token);
		%if &l > &res %then %do;
			%let res = &l;
		%end;
	%end;

	%eval(&res)
%mend;


%macro BICModelIsOk(outok, outphregmodel, outinternterms, outinterntermsinmodel, model, safeprefix, force);
	%local dsForced dsForcedIsIn dsLov dsLovUniq dsUniqterms dsMinOrder;
	%local forcedvars0 i internterms j lmax lmaxf lmaxi lov lovNoStar modelinternterms modelorder nforce nterms o ok orders phregmodel t terms;

	%let lov = %sysfunc(tranwrd(%sysfunc(tranwrd(%sysfunc(compbl(&model)), %str(* ), %str(*))), %str( *), %str(*)));
	%let lovNoStar = %sysfunc(tranwrd(&lov, %str(*), %str( )));

	%let lmax		= %BIClmax(&lovNoStar);
	%let lmaxi		= %BIClmax(&lov);
	%let nterms	= %BICntokens(&lov);

	%let &outinternterms =;

	%let dsLov = %BICNewDatasetName(lov);

	data &dsLov;
		length term	$&lmaxi;
		length ucname	$&lmax;
		%do i = 1 %to &nterms;
			%let t = %scan(&lov, &i, %str( ));
			term = "&t";

			if index(term, "*") > 0 then do;
				order = 2;
				ucname = upcase(scan(term, 1));
				output;
				ucname = upcase(scan(term, 2));
				output;
			end;
			else do;
				order = 1;
				ucname = upcase(term);
				output;
			end;
		%end;
	run;

	%let dsMinOrder = %BICNewDatasetName(minorder);

	proc sql;
		create table &dsMinOrder as
		select ucname, min(order) as MinOrder
		from &dsLov
		group ucname;
	quit;

	proc sql noprint;
		select max(MinOrder) = 1 into :ok
		from &dsMinOrder;
	quit;

	%if %length(&force) and &ok %then %do;
		* Check that each forced term is in model;

		%let dsLovUniq = %BICNewDatasetName(lovUniq);

		proc sql;
			create table &dsLovUniq as
			select distinct(upcase(term)) as ucterm
			from &dsLov;
		quit;

		%let forcedvars0 = %sysfunc(tranwrd(%sysfunc(tranwrd(%sysfunc(compbl(&force)), %str(* ), %str(*))), %str( *), %str(*)));
		%let nforce = %BICntokens(&forcedvars0);
		%let lmaxf	= %BIClmax(&forcedvars0);
		%if &lmaxf < &lmaxi %then %let lmaxf = &lmaxi;

		%let dsForced = %BICNewDatasetName(forcedvars);

		data &dsForced (drop=term1 term2);
			length term $&lmaxf;
			%do i = 1 %to &nforce;
				%let t = %scan(&forcedvars0, &i, %str( ));
				term = upcase("&t");

				if index(term, "*") > 0 then do;
					term1 = scan(term, 1);
					term2 = scan(term, 2);
					ucterm = catx("*", term1, term2);
					output;
					ucterm = catx("*", term2, term1);
					output;
				end;
				else do;
					ucterm = term;
					output;
				end;
			%end;
		run;

		proc sort data=&dsForced; by ucterm; run;
		proc sort data=&dsLovUniq; by ucterm; run;

		data &dsForced;
			merge &dsForced (in=in1) &dsLovUniq (in=in2);
			by ucterm;
			if in1;
			inModel = in2;
		run;

		%let dsForcedIsIn = %BICNewDatasetName(forcedisin);

		proc sql;
			create table &dsForcedIsIn as
			select term, max(inModel) as inModel
			from &dsForced
			group term;
		quit;

		proc sql noprint;
			select min(inModel) = 1 into :ok
			from &dsForcedIsIn;
		quit;

		proc datasets nolist; delete &dsForced &dsForcedIsIn &dsLovUniq; run;
	%end;

	%if &ok %then %do;
		proc sql noprint;
			select max(order) into: modelorder
			from &dsLov;
		quit;

		%if &modelorder > 1 %then %do;
			%let dsUniqterms = %BICNewDatasetName(tmp);

			proc sql;
				create table &dsUniqterms as
				select order, term, N(term) as _dummy
				from &dsLov
				group order, term;
			quit;

			proc sql noprint;
				select order, term, N(term) into :orders separated by ' ', :terms separated by ' ', :nterms
				from &dsUniqterms;
			quit;

			%let j = 0;

			%do i = 1 %to &nterms;
				%let o = %scan(&orders, &i);
				%let t = %scan(&terms, &i, %str( ));

				%if &o > 1 %then %do;
					%let j = %sysfunc(compress(%eval(&j + 1)));
					%let phregmodel = &phregmodel &safeprefix&j;
					%let internterms = &internterms &t;
					%let modelinternterms = &modelinternterms &safeprefix&j;
				%end;
				%else %do;
					%let phregmodel = &phregmodel &t;
				%end;
			%end;

			%let &outinternterms				= &internterms;
			%let &outphregmodel				= &phregmodel;
			%let &outinterntermsinmodel	= &modelinternterms;

			proc datasets nolist; delete &dsUniqterms; run;
		%end;
		%else %do;
			%let &outphregmodel = &model;
		%end;
	%end;

	%let &outok = &ok;

	proc datasets nolist; delete &dsLov &dsMinOrder; run;
%mend;


%macro BICNewDatasetName(proposalname);
	%*Finds the first unused dataset named  *datasetname*, adding a leading underscore and a numeric suffix as large as necessary to make it unique!;
	%local i newdatasetname;
	%let proposalname=%sysfunc(compress(&proposalname));
	%let newdatasetname=_&proposalname;

	%do %while(%sysfunc(exist(&newdatasetname)));
		%let i = %eval(&i+1);
		%let newdatasetname=_&proposalname&i;
	%end;

	&newdatasetname
%mend;


%macro BICNormalMixtureQuantiles(out=, data=, mu=Estimate, sd=StdErr, wt=ModelProb, conditional=0, probEpsilon=1e-8, probs=0.025 0.5 0.975);
	%local cond d i inf LCL Med nprobs p p0 p0Degenerate pDegenerate ptarget sup totwt UCL x xnew;

	%let nprobs = 3;

	* Reserve output file name;
	data &out; stop; run;

	%if not &conditional %then %do;
		proc sql noprint;
			select sum(&wt*cdf('normal', 0, &mu, &sd)), 1-sum(&wt) into :p0, :pDegenerate
			from &data;
		quit;

		%let p0Degenerate = %sysevalf(&p0+&pDegenerate);
	%end;


	%do i = 1 %to &nprobs;
		%let p = %scan(&probs, &i, %str( ));
		%let ptarget = &p;
		%let cond = 1;

		%if not &conditional %then %do;
			%if %sysevalf(&p lt &p0, boolean) %then %do;
				%let ptarget = %sysevalf(&p/(1-&pDegenerate));
				proc sql noprint; select min(quantile('normal', &ptarget, &mu, &sd)), max(quantile('normal', &ptarget, &mu, &sd)) into :inf, :sup from &data; quit;
				%let ptarget = &p;
				%if %sysevalf(&sup gt 0, boolean) %then %let sup = 0;
			%end;
			%else %if %sysevalf(&p le &p0Degenerate, boolean) %then %do;
				%let x = 0;
				%let cond = 0;
			%end;
			%else %do;
				%let ptarget = %sysevalf((&p-&pDegenerate)/(1-&pDegenerate));
				proc sql noprint; select min(quantile('normal', &ptarget, &mu, &sd)), max(quantile('normal', &ptarget, &mu, &sd)) into :inf, :sup from &data; quit;
				%if %sysevalf(&inf lt 0, boolean) %then %let inf = 0;
				%let ptarget = %sysevalf(&p-&pDegenerate);
			%end;
		%end;
		%else %do;
			proc sql noprint; select min(quantile('normal', &p, &mu, &sd)), max(quantile('normal', &p, &mu, &sd)), sum(&wt) into :inf, :sup, :totwt from &data; quit;
			%let ptarget = %sysevalf(&p*&totwt);
		%end;
		

		%if &cond %then %let x = %sysevalf((&inf+&sup)/2);

		%do %while(&cond);
			proc sql noprint;
				select (sum(&wt*cdf('normal', &x, &mu, &sd))-&ptarget)/sum(&wt*pdf('normal', &x, &mu, &sd)) into :d
				from &data;
			quit;

			%let xnew = %sysevalf(&x-&d);

			%if %sysevalf(&xnew lt &inf, boolean) %then %do;
				%let sup = &x;
				%let d = %sysevalf((&x-&inf)/2);
				%let x = %sysevalf((&x+&inf)/2);
			%end;
			%else %if %sysevalf(&xnew gt &sup, boolean) %then %do;
				%let inf = &x;
				%let d = %sysevalf((&sup-&x)/2);
				%let x = %sysevalf((&x+&sup)/2);
			%end;
			%else %do;
				%if %sysevalf(&d gt 0) %then %let sup = &x;
				%else %let inf = &x;

				%let x = &xnew;
			%end;

			%let cond = %sysevalf(%sysfunc(abs(&d)) > &probEpsilon, boolean);
		%end;

		%if			&i eq 1	%then %let LCL = &x;
		%else %if	&i eq 2	%then %let Med = &x;
		%else %if	&i eq 3	%then %let UCL = &x;
	%end;

	data &out; Med = &Med; LCL = &LCL; UCL = &UCL; output; run;
%mend;


%macro BICntokens(list);
	%eval(1 + %length(%sysfunc(compbl(&list))) - %length(%sysfunc(compress(&list))))
%mend;


%macro BICSomeParm(dsParms, outparm, parmname=Parameter);
	%local dsTmp;
	%local outparmname;

	%let dsTmp = %BICNewDatasetName(tmp);
	proc sql;
		create table &dsTmp as
		select distinct(&parmname) as Parameter
		from &dsParms;
	quit;

	data &dsTmp;
		set &dsTmp;
		AnySpace = AnySpace(strip(Parameter));
	run;
	proc sort data=&dsTmp; by AnySpace; run;

	data &dsTmp;
		set &dsTmp;
		lineno = _N_;
	run;

	proc sql noprint; select Parameter into :outparmname from &dsTmp where lineno eq 1; quit;
	proc datasets nolist; delete &dsTmp; quit;

	%let &outparm = &outparmname;
%mend;
