   *               _\|/_
                   (o o)
    +----oOO-{_}-OOo----------------------------------------------------------------------------+
    :                                                                                                                           :
    :   AnyOf 			(version 1.3, June 2013)                                                             :
	: 	MeanOf                                                                                                          :
	:    NOf																							     				  :
    :    SumOf                                                                                                         :
    :                                                                                                                       :
    :    Calculating the mean or the sum of a series of variables in proc sql         :
    :                                                                                                                     :
    :     http://www.medicine.mcgill.ca/epidemiology/Joseph/PBelisle                  :
    +--------------------------------------------------------------------------------------------;


%macro AnyOf(vars=, calculated=, cond=eq 1);
	%local mc mv n v;
	%local allvars var;

	%if %length(%superq(vars)) eq 0 %then %let mv = 0;
	%else %let mv = %ntokens(&vars);

	%if %length(%superq(calculated)) eq 0 %then %let mc = 0;
	%else %let mc = %ntokens(&calculated);

	%let allvars = &vars &calculated;
	%let n = %eval(&mv + &mc);

	%do v = 1 %to &n;
		%let var = %scan(&allvars, &v);
		%if &v gt 1 %then %do;
			or
		%end;
		%if &v gt &mv %then %do;
			calculated
		%end;
		&var &cond
	%end;
%mend AnyOf;


%macro MeanOf(vars=, calculated=);
	%local dim i v mv mc n;
	%local calculated allvars;

	%if %length(%superq(vars)) eq 0 %then %let mv = 0;
	%else %let mv = %ntokens(&vars);

	%if %length(%superq(calculated)) eq 0 %then %let mc = 0;
	%else %let mc = %ntokens(&calculated);

	%if &mv eq 0 and &mc eq 0 %then %do;
		.
	%end;
	%else %do; 
		%let allvars = &vars &calculated;
		%let n = %eval(&mv + &mc);

		ifn(
		%do dim = 0 %to 2;
			/*dim = 0 for condition, 1 for numerator, 2 for denominator */
			%let calculated = 0;

			%do i = 1 %to &n;
				%if &i gt &mv %then %let calculated = 1;
				%let v = %scan(&allvars, &i);
				%if &calculated %then %let v = calculated &v;

				%if &i gt 1 %then %do;
					%if &dim eq 0 %then %do;
						or
					%end;
					%else %do;
						+
					%end;
				%end;

				%if &dim eq 0 %then %do;
					not missing(&v)
				%end;
				%else %if &dim eq 1 %then %do;
					coalesce(&v, 0)
				%end;
				%else %do;
					(not missing(&v))
				%end;
			%end;

			%if &dim eq 0 %then %do;
				, (
			%end;
			%else %if &dim eq 1 %then %do;
				) / (
			%end;
			%else %do;
				)
			%end;
		%end;
		, .)
	%end;
%mend MeanOf;


%macro NOf(vars=, calculated=);
	%local i v mv mc n;
	%local calculated allvars;

	%if %length(%superq(vars)) eq 0 %then %let mv = 0;
	%else %let mv = %ntokens(&vars);

	%if %length(%superq(calculated)) eq 0 %then %let mc = 0;
	%else %let mc = %ntokens(&calculated);

	%if &mv eq 0 and &mc eq 0 %then %do;
		.
	%end;
	%else %do; 
		%let allvars = &vars &calculated;
		%let n = %eval(&mv + &mc);
		%let calculated = 0;

		%do i = 1 %to &n;
			%if &i gt &mv %then %let calculated = 1;
			%let v = %scan(&allvars, &i);
			%if &calculated %then %let v = calculated &v;

			%if &i gt 1 %then %do;
				+
			%end;
			(not missing(&v))
		%end;
	%end;
%mend NOf;


%macro SumOf(vars=, calculated=);
	%local dim i v mv mc n;
	%local calculated allvars;

	%if %length(%superq(vars)) eq 0 %then %let mv = 0;
	%else %let mv = %ntokens(&vars);

	%if %length(%superq(calculated)) eq 0 %then %let mc = 0;
	%else %let mc = %ntokens(&calculated);

	%if &mv eq 0 and &mc eq 0 %then %do;
		.
	%end;
	%else %do; 
		%let allvars = &vars &calculated;
		%let n = %eval(&mv + &mc);

		ifn(
		%do dim = 0 %to 1;
			/*dim = 0 for condition, 1 for numerator */
			%let calculated = 0;

			%do i = 1 %to &n;
				%if &i gt &mv %then %let calculated = 1;
				%let v = %scan(&allvars, &i);
				%if &calculated %then %let v = calculated &v;

				%if &i gt 1 %then %do;
					%if &dim eq 0 %then %do;
						or
					%end;
					%else %do;
						+
					%end;
				%end;

				%if &dim eq 0 %then %do;
					not missing(&v)
				%end;
				%else %do;
					coalesce(&v, 0)
				%end;

			%end;

			%if &dim eq 0 %then %do;
				, (
			%end;
			%else %do;
				)
			%end;
		%end;
		, .)
	%end;
%mend SumOf;



%macro ntokens(list);
	%eval(1 + %length(%sysfunc(compbl(&list))) - %length(%sysfunc(compress(&list))))
%mend ntokens;
