/* ~~~~~~~~~~ Example 1 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */;

proc format;
	value gender
		0 = 'female'
		1 = 'male'
		;
	value visitno
		1 = 'baseline'
		2 = 'week 1'
		3 = 'week 4'
		;
run;

data ex1;
	input centre subjectno gender visit sbp wt;
	label gender = 'Patient sex';
	format 
		gender gender.
		visit visitno.
		;
cards;
1 1 0 1 120 75
1 1 0 2 125 75.5
1 1 0 3 120 75.7
1 2 1 1 140 70
1 2 1 2 145 73
2 1 0 1 155 90
2 1 0 2 150 90.8
2 1 0 3 155 91.2
;
run;

proc sql;
	create table avgs as
	select centre, subjectno, gender, .a as visit, mean(sbp) as sbp, mean(wt) as wt
	from ex1
	group centre, subjectno, gender;
quit;
proc datasets nolist; append data=avgs base=ex1; delete avgs; quit;
proc sort data=ex1; by centre subjectno visit; run;

proc print data=ex1; run;

%MultiTranspose(data=ex1, out=out1, vars=sbp wt, by=centre subjectno, pivot=visit, library=work);
proc print data=out1; run;
proc contents data=out1; run;


/* Example 1.1 */;
%MultiTranspose(data=ex1, out=out1_1, vars=sbp wt, by=centre subjectno, pivot=visit, dropMissingPivot=0, library=work);
proc print data=out1_1; run;
proc contents data=out1_1; run;


%MultiTranspose(data=ex1, out=out1_2, vars=sbp wt, by=centre subjectno, pivot=visit, copy=gender, library=work);
proc print data=out1_2; run;

proc datasets nolist; delete ex1 out1 out1_1 out1_2; quit;


/* ~~~~~~~~~~ Example 2 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */;


data ex2; 
input ACCT OBS_DT date9. HBAL_AMT MBAL_AMT;
format obs_dt date9.;
cards; 
 13607354 30SEP2007 5.57 5.57
 13607354 31OCT2007 5.57 5.57
 13607354 30NOV2007 5.57 5.57
 13607354 31DEC2007 5.57 5.57
 13607354 31JAN2008 402.72 402.72
 13873620 30SEP2007 15.00 15.00
 13873620 31OCT2007 15.00 15.00
 13873620 30NOV2007 0.00 0.00
 13873620 31DEC2007 0.00 0.00
 13873620 31JAN2008 0.00 0.00
run; 
proc print data=ex2; run;

%MultiTranspose(data=ex2, out=out2, by=acct, pivot=OBS_DT, vars=HBAL_AMT MBAL_AMT, library=work);

proc print data=out2; run;
proc contents data=out2; run;

proc datasets nolist; delete ex2 out2; quit;


/* ~~~~~~~~~~ Example 3 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */;


data ex3;
input item flavor $ price qty;
cards;
1 v 17 102
1 c 19 95
2 v 25 32
2 c 28 35
;
run;
proc print data=ex3; run;

%MultiTranspose(data=ex3, out=out3, by=item, vars=price qty, pivot=flavor, library=work);
proc print data=out3; run;

%MultiTranspose(data=ex3, out=out3num, by=item, vars=price qty, pivot=flavor, UseNumericExt=1, library=work);
proc print data=out3num; run;
proc contents data=out3num; run;


proc datasets nolist; delete ex3 out3 out3num; quit;
