*! bkup ver 1.1 10nov2007
*! backup new and modified files to zip-file.
*! Author: Svend Juul

program bkup
version 9
syntax [, Full]

// Personalize bkup.ado:
// =====================
// Define your main personal folder
local MAIN "c:\dokumenter"
// Define folder to store backup-files
local BKUP "c:\backup"
// Define location of WinZip program
local WZZIP "c:\Programmer\winzip\wzzip"


// Create local macros for current date and time
local D: display %dCYND date("`c(current_date)'","dmy")
local T = c(current_time)
local T = substr("`T'",1,2)+substr("`T'",4,2)

// Full or incremental backup?
if "`full'" != "" {
   ! attrib +a "`MAIN'/*.*" /s >nul
   ! attrib +a "`c(sysdir_personal)'*.*" /s >nul
}

// Some file types we don't want to backup.
// Their archive attribute is turned off.
! attrib -a "`MAIN'/*.tmp" /s >nul
! attrib -a "`MAIN'/*.bak" /s >nul
! attrib -a "`MAIN'/*.wbk" /s >nul
! attrib -a "`c(sysdir_personal)'*.tmp" /s >nul
! attrib -a "`c(sysdir_personal)'*.bak" /s >nul

// Make a zip-file with the current date and time as name,
// including new and modified files (or, in case of a
// full backup, all files) from your main folder
// and from your personal ado-folder.
winexec "`WZZIP'" -rP -i ///
   "`BKUP'/sj.`D'`T'.zip" ///
   "`MAIN'/*.*"  "`c(sysdir_personal)'*.*"

display ""
display "`BKUP'/sj.`D'`T'.zip created"
end
