{smcl}
{cmd:help cisd2}
{hline}

{title:Title}
{phang}

{bf:cisd2} {hline 2} Estimation of measurement variation from dual interchangeable measurements.

{title:Syntax}

{p 8 17 2}
{bf:cisd2} {it:varname} [, level(#)]

{title:Description}

With dual interchangeable measurements, the {bf:loneway} command
estimates the measurement error, to be displayed as 
{bf:Estimated SD within id}. However, the uncertainty of this
estimate is not displayed. {bf:cisd2} takes the difference between
two variables as input and calculates the confidence interval for
the estimated SD.

{it:varname} is the name of a variable containing the difference
between the dual measurements. It is input as the sole variable in
a {bf:regress} command with the {bf:noconstant} option.

{bf:cisd2} displays the SD(error) estimate with confidence interval
for the difference variable and for the individual measurements,
by dividing by sqrt(2). 

The 95% confidence limits for an SD estimate are functions of SD 
and DF (degrees of freedom):
	Lower limit: SD*sqrt(DF/invchi2(DF,0.975))
	Upper limit: SD*sqrt(DF/invchi2(DF,0.025))


{title:Examples}

	{inp:. generate dif = sbp1-sbp2}
	{inp:. cisd2 dif}
	{inp:. cisd2 dif , level(90)}

{title:Authors}

Morten Frydenberg and Svend Juul
School of Public Health, Aarhus University, Danmark
Email: {browse "mailto:morten@biostat.au.dk":morten@biostat.au.dk}



