* gen_oppatients2.do

* Choose the directory where you store the files for the book.
* In the book's examples the command is -cd C:\docs\ishr3-

use oppatients1.dta, clear

* -stset- data; age is time axis
stset enddate, enter(begdate) origin(bdate) failure(died==1) ///
   scale(365.25) id(patid)

* split information in age bands (agegr)
stsplit agegr, at(0 1 5(5)100)
label variable agegr "Age band"

* Merge age- and sex-specific reference mortality rates to data
sort sex agegr
merge m:1 sex agegr using "dk1991-95.dta"
drop if _merge<3       // Some age bands in the reference mortality rate file
drop _merge            // had no match in the actual dataset; they are dropped

label data "Patient data, stsplit and merged with population rates"
saveold oppatients2.dta, replace

