* gph_fig17_34.do
 
sysuse cancer.dta       // Use the cancer.dta dataset accompanying Stata
keep if drug==2         // Study the 14 patients who received drug 2
sort studytime          // Sort by observation time
gen patient=_n          // and give numbers to patients

set scheme lean2

twoway                                                             ///
  (dropline studytime patient if died==1, horizontal msymbol(D))   ///
  (dropline studytime patient if died==0, horizontal msymbol(D)    ///
     mfcolor(white))                                               ///
  ,                                                                ///
  plotregion(margin(l=0 b=0))                                      ///
  ytitle("Patient number")                                         /// 
  yscale(range(0 14))  ylabel(1 5 10 14, nogrid)                   ///
  xtitle("Months after randomization")                             ///
  xlabel(0(6)30)                                                   ///
  legend(order(1 "Death" 2 "Censoring"))                           ///
  xsize(4.4) ysize(2.2) scale(1.4)
