.ss.bsearch <-
function(mylist)
{
  ##################################################################
  # mylist: consists in a list of the following arguments:
  # -------
  #
  # n.visited
  # outcome
  # n.max
  # mcs
  # min.for.possible.return
  # target
  # step0
  # increasing.outcome.with.n  
  #
  ##################################################################

  all.same.dir <- function(nvisited){length(unique(sign(diff(nvisited)))) == 1}

  #

  last.outcome <- mylist$outcome[1]
  dir <- ifelse(last.outcome==mylist$target, -1,
                ifelse(mylist$increasing.outcome.with.n, -1, 1)*sign(last.outcome-mylist$target))
  continue <- T

  if (length(mylist$n.visited) == 1)
  {
    n <- ifelse(dir == 1, mylist$n.visited + dir * mylist$step0, floor(mylist$n.visited/2))
    n <- min(max(0, n), mylist$n.max)
  }
  else
  {
    steps <- -diff(mylist$n.visited)

    if (abs(steps[1]) == 1 && length(unique(sign(mylist$outcome[1:2]-mylist$target))) == 2)
    {
      cond <- ifelse(rep(mylist$increasing.outcome.with.n, 2),
                     mylist$outcome[1:2] >= mylist$target, mylist$outcome[1:2] <= mylist$target)
      n <- min(mylist$n.visited[1:2][cond])
      continue <- F
    }
    else if (length(mylist$n.visited) > mylist$mcs && all(mylist$n.visited[1:(mylist$mcs+1)]==mylist$n.max) && dir == 1)
    {
      n <- mylist$n.max
      continue <- F
    }
    else if (length(mylist$n.visited) > mylist$mcs && all(mylist$n.visited[1:(mylist$mcs+1)]==0) && dir == -1)
    {
      n <- 0
      continue <- F
    }
    else if (mylist$n.visited[1] == max(mylist$n.visited) && dir == 1 && abs(steps[1]) != 1)
    {
      n <- mylist$n.visited[1] + 2*max(abs(diff(mylist$n.visited)))
      n <- min(n, mylist$n.max)
    }
    else if (mylist$n.visited[1] == min(mylist$n.visited) && dir == -1 && abs(steps[1]) != 1)
    {
      n <- floor(mylist$n.visited[1]/2)
    }
    else
    {
      possible.to.move.back <- abs(steps[1]) > mylist$min.for.possible.return

      if (possible.to.move.back && length(mylist$n.visited) > mylist$mcs && all.same.dir(mylist$n.visited[1:(mylist$mcs+1)]) && sign(steps[1]) == dir && 
          (length(mylist$n.visited) == (mylist$mcs+1) || !all.same.dir(mylist$n.visited[1:(mylist$mcs+2)])) )
      {
        n <- mylist$n.visited[mylist$mcs+2]
      }
      else
      {
        if (abs(steps[1]) == 1)
        {
          m <- mylist$n.visited[1] + dir
        }
        else
        {
          d <- mylist$n.visited - mylist$n.visited[1]
          m <- mylist$n.visited[sign(d)==dir][1]
          m <- ceiling((mylist$n.visited[1]+m)/2)
        }

        if (dir == 1)
        {
          n <- max(m, mylist$n.visited[1]+1)
        }
        else
        {
          n <- min(m, mylist$n.visited[1]-1)
        }

        n <- min(n, mylist$n.max)
        n <- max(0, n)
      }
    }
  }

  # If continue=F, then n indicates the optimal sample size found

  list(n=n, continue=continue)
}
.ss.cons.binom.check.list <-
function(test.prior=list(), prior.name, len=2, accept.null.list=F)
{
  if (missing(test.prior))
  {
    stop(paste(c(prior.name, " list undefined."), collapse=''), call.=F) 
  }
  else
  {
    tmp <- try(paste(test.prior), silent=T)
    if (class(tmp) != "try-error")
    {
      dim.names <- names(test.prior)
      present.dim <- match(c("alpha", "beta"), dim.names)
      if (any(is.na(present.dim)))
      { 
        stop(paste(c("Both alpha and beta must be dimensions of ", prior.name, " list."), collapse=''), call.=F)
      }
      else
      {
        parms.len <- c(length(test.prior$alpha), length(test.prior$beta))
        if (accept.null.list)
        {
          if (!all(parms.len==len) && !all(parms.len==0)) stop(paste(c("Both $alpha and $beta in ", prior.name, " list must be of length ", len, " (or left empty, that is, with length = 0)"), collapse=''), call.=F)
        }
        else
        { 
          if (!all(parms.len==len)) stop(paste(c("Both $alpha and $beta in ", prior.name, " list must be of length ", len), collapse=''), call.=F)
        }
      }
    }
    else
    {
      stop(paste(c(prior.name, " list undefined."), collapse=''), call.=F)
    }
  }
}
.ss.cons.2binom.cdf <-
function(cdf.points, accepted.cdf.diff, prior1, prior2,  
                                               n.start, n.max, sim.size, next.n=.ss.mixed.nextn,  
                                               clinical.prior=list(), prior1.mixture.wt=0.5,
                                               target, both=F, return.worst=F, return.prob=F, epsilon=1e-8, n2.n1.ratio=1, mcs=3, min.for.possible.return=2^ceiling(1.5*mcs))
{
  # prior1, prior2 and clinical.prior must be lists with dimensions alpha & beta
  
  increasing.outcome.with.n <- return.prob
        
  if (!is.loaded('BinomConsensus')) 
  {
    path <- "c:/users/patrick.belisle/My Documents/Home/SampleSize/ConsensusBased/binom/dll"
    file.name <- "ConsensusBinomial"
    Running.on.64Bytes <- length(grep("64", R.Version()$arch)) > 0
    file.suffx <- character(0)
    if (!Running.on.64Bytes) file.suffx <- "-32bytes"
    dll <- paste(c(path, "/", file.name, file.suffx, ".dll"), collapse="")
    dyn.load(dll)
  }
  
  
  if (length(cdf.points) > 1) cdf.points <- sort(unique(cdf.points))
  m.comparison.points <- length(cdf.points)
  cdf.points.rescaled <- (cdf.points+1)/2 # rescaled to 0/1 beta distrn range
  

  # Initial values

  n1 <- min(n.start, n.max)
  step0 <- max(ceiling(n1/100), 10) # Initial step
  outcome <- numeric(0)
  n.visited <- numeric(0)
  estimated.from.sampling <- logical(0)

  out <- list(continue=T, target=target, increasing.outcome.with.n=increasing.outcome.with.n, step0=step0, n.max=n.max, mcs=mcs, min.for.possible.return=min.for.possible.return)
  prior.alphas <- c(prior1$alpha, prior2$alpha)
  prior.betas  <- c(prior1$beta,  prior2$beta)


  while (out$continue)
  {
    n <- ceiling(n1*c(1, n2.n1.ratio))
    
    post.moments <- .ss.cons.2binom.post.moments(n, prior1, prior2,
      clinical.prior, prior1.mixture.wt, sim.size, both)
      
    if (post.moments$rnd)
    {
      alphas <- c(post.moments$specialist1$alpha, post.moments$specialist2$alpha)
      betas  <- c(post.moments$specialist1$beta,  post.moments$specialist2$beta)
      alphas.len <- length(alphas)
          
      cdf.points <- cdf.points.rescaled
      if (m.comparison.points > 1) cdf.points <- rep(cdf.points, rep(alphas.len, m.comparison.points))
      cdf <- pbeta(cdf.points, alphas, betas)    
      is.specialist1.cdf <- rep(c(T,F), rep(alphas.len/2, 2))
      cdf.diff <- abs(cdf[!is.specialist1.cdf] - cdf[is.specialist1.cdf])
      if (m.comparison.points > 1)
      {
        cdf.diff <- matrix(cdf.diff, ncol=m.comparison.points)
        cdf.diff <- apply(cdf.diff, 1, max) 
      }

      tmp <- .ss.cons.2binom.outcome(accepted.cdf.diff, cdf.diff, post.moments$f, return.worst, return.prob, increasing.outcome.with.n)
    }
    else
    {
      tmp <- .C('BetaDiff4NonRnd', todo=as.integer(1), lz=m.comparison.points, z=cdf.points.rescaled, n, as.integer(both), as.double(accepted.cdf.diff), as.double(prior.alphas), as.double(prior.betas),
                                   as.double(post.moments$pr1), as.double(post.moments$pr2), as.integer(return.worst), as.integer(return.prob), out=double(1))  
      tmp <- tmp$out
    }

    outcome <- c(tmp, outcome)
    n.visited <- c(n1, n.visited)
    estimated.from.sampling <- c(post.moments$rnd, estimated.from.sampling)

    out$outcome <- outcome
    out$n.visited <- n.visited
    out$estimated.from.sampling <- estimated.from.sampling

    nextn <- next.n(out, sim.size)
    out$continue <- nextn$continue
    n1 <- nextn$n
  }
  
  n <- ceiling(n1*c(1, n2.n1.ratio))

  list(n=n, n.visited=rev(out$n.visited), outcome=rev(out$outcome), estimated.from.sampling=rev(out$estimated.from.sampling))
}
.ss.cons.2binom.hpdlimits <-
function(accepted.pdiff, prior1, prior2, 
                                               level, 
                                               n.start, n.max, next.n=.ss.mixed.nextn, sim.size, 
                                               clinical.prior=list(), prior1.mixture.wt=0.5,
                                               target, both=F, return.worst=F, return.prob=F, epsilon=1e-8, n2.n1.ratio=1, mcs=3, min.for.possible.return=2^ceiling(1.5*mcs))
{
  # prior1, prior2 and clinical.prior must be lists with dimensions alpha & beta
  
  increasing.outcome.with.n <- return.prob
        
  if (!is.loaded('BinomConsensus')) 
  {
    path <- "c:/users/patrick.belisle/My Documents/Home/SampleSize/ConsensusBased/binom/dll"
    file.name <- "ConsensusBinomial"
    Running.on.64Bytes <- length(grep("64", R.Version()$arch)) > 0
    file.suffx <- character(0)
    if (!Running.on.64Bytes) file.suffx <- "-32bytes"
    dll <- paste(c(path, "/", file.name, file.suffx, ".dll"), collapse="")
    dyn.load(dll)
  }

  # Initial values

  n1 <- min(n.start, n.max)
  step0 <- max(ceiling(n1/100), 10) # Initial step
  outcome <- numeric(0)
  n.visited <- numeric(0)
  estimated.from.sampling <- logical(0)
  

  out <- list(continue=T, target=target, increasing.outcome.with.n=increasing.outcome.with.n, step0=step0, n.max=n.max, mcs=mcs, min.for.possible.return=min.for.possible.return)
  prior.alphas <- c(prior1$alpha, prior2$alpha)
  prior.betas  <- c(prior1$beta,  prior2$beta)


  while (out$continue)
  {
    n <- ceiling(n1*c(1, n2.n1.ratio))
    
    post.moments <- .ss.cons.2binom.post.moments(n, prior1, prior2,
      clinical.prior, prior1.mixture.wt, sim.size, both)
      
    if (post.moments$rnd)
    {
      alphas <- c(post.moments$specialist1$alpha, post.moments$specialist2$alpha)
      betas  <- c(post.moments$specialist1$beta,  post.moments$specialist2$beta)
      alphas.len <- length(alphas)
  
      z <- .C("BetaHPD", as.integer(0), as.double(level), alphas.len, as.double(alphas), as.double(betas), as.double(epsilon), as.integer(1), res=double(2*alphas.len))
      hpd <- matrix(z$res, byrow=T, ncol=2)
      hpd1 <- hpd[ seq(alphas.len/2),]
      hpd2 <- hpd[-seq(alphas.len/2),]
      hpd.diff <- 2*apply(abs(hpd2-hpd1),1,max) # multiplied by 2 to convert to -1/1 scale
     
      tmp <- .ss.cons.2binom.outcome(accepted.pdiff, hpd.diff, post.moments$f, return.worst, return.prob, increasing.outcome.with.n)
    }
    else
    {
      tmp <- .C('BetaDiff4NonRnd', todo=as.integer(0), lz=as.integer(1), z=level, n, as.integer(both), as.double(accepted.pdiff), as.double(prior.alphas), as.double(prior.betas),
                                   as.double(post.moments$pr1), as.double(post.moments$pr2), as.integer(return.worst), as.integer(return.prob), out=double(1))  
      tmp <- tmp$out
    }
  

    outcome <- c(tmp, outcome)
    n.visited <- c(n1, n.visited)
    estimated.from.sampling <- c(post.moments$rnd, estimated.from.sampling)

    out$outcome <- outcome
    out$n.visited <- n.visited
    out$estimated.from.sampling <- estimated.from.sampling

    nextn <- next.n(out, sim.size)
    out$continue <- nextn$continue
    n1 <- nextn$n
  }
  
  n <- ceiling(n1*c(1, n2.n1.ratio))

  list(n=n, n.visited=rev(out$n.visited), outcome=rev(out$outcome), estimated.from.sampling=rev(out$estimated.from.sampling))
}
.ss.cons.2binom.outcome <-
function(target, z, f, return.worst, return.prob, increasing.outcome.with.n)
{
  colsum <- function(m){as.vector(matrix(1,nrow=1,ncol=nrow(m))%*%m)}
  both <- is.matrix(f)

  if (return.worst)
  {
    if (increasing.outcome.with.n)
    {
      out <- min(z)
    }
    else
    {
      out <- max(z)
    }
  }
  else if (return.prob)
  {
    ncol <- ifelse(both, 2, 1)
    f <- matrix(f, ncol=ncol)
    w <- which(z<=target)
    f <- f[w,,drop=F]
    out <- colsum(f)
    out <- min(out)
  }
  else
  {
    # return avg
    ncol <- ifelse(both, 2, 1)
    f <- matrix(f, ncol=ncol)
    avg <- colsum(f*z)
    out <- max(avg)
  }
  
  out
}
.ss.cons.2binom.post.moments <-
function(n, 
  prior1, prior2,
  clinical.prior=list(), prior1.mixture.wt=0.5,
  sim.size=50000, both=F)
{
  # --- Useful functions -------------------------------------------------------------
  
  betadiff.moments <- function(group1.moments, group2.moments, xSample, both, specialist1=T)
  {
    # called only when xSample$rnd == T
    
    f <- xSample$f
    mean1 <- group1.moments$mean
    mean2 <- group2.moments$mean
    var1  <- group1.moments$var
    var2  <- group2.moments$var

    diff.mean <- mean2 - mean1
    diff.var  <- var1  + var2

    list(mean=diff.mean, var=diff.var, f=f)
  } # end of betadiff.moments


  beta.moments <- function(parms.list)
  {
    a <- parms.list$alpha
    b <- parms.list$beta

    m <- a/(a+b)
    v <- a*b/(a+b)/(a+b)/(a+b+1)
                                                                   
    list(mean=m, var=v)
  } # end of beta.moments


  beta.parms.from.moments <- function(m, v)
  {  
    a <- m*m*(1-m)/v-m
    b <- a*(1/m-1)

    list(alpha=a,beta=b)
  } # end of beta.parms.from.moments
  
  
  combined.tables <- function(table1, table2)
  {
    names1 <- names(table1)
    names2 <- names(table2)
    
    x1.x2 <- unique(c(names1, names2))
    f <- matrix(0, nrow=length(x1.x2), ncol=2)
    
    w <- seq(along=table1)
    f[w,1] <- table1
    
    w <- match(names2, x1.x2)
    f[w,2] <- table2
    
    x1.x2 <- matrix(as.integer(unlist(strsplit(x1.x2, ';'))), ncol=2, byrow=T)

    list(x1=x1.x2[,1], x2=x1.x2[,2], f=f)
  } # end of combined.tables


  diff.moments <- function(n, xSample, prior2, prior1, both)
  {
    # called only when xSample$rnd = T
    x1 <- xSample$x1
    x2 <- xSample$x2 

    specialist1.group1.parms <- list(alpha=x1+prior2$alpha[1], beta=n[1]-x1+prior2$beta[1])
    specialist1.group2.parms <- list(alpha=x2+prior2$alpha[2], beta=n[2]-x2+prior2$beta[2])

    specialist2.group1.parms <- list(alpha=x1+prior1$alpha[1], beta=n[1]-x1+prior1$beta[1])
    specialist2.group2.parms <- list(alpha=x2+prior1$alpha[2], beta=n[2]-x2+prior1$beta[2])


    specialist1.group1.moments <- beta.moments(specialist1.group1.parms)
    specialist1.group2.moments <- beta.moments(specialist1.group2.parms)
    
    specialist2.group1.moments <- beta.moments(specialist2.group1.parms)
    specialist2.group2.moments <- beta.moments(specialist2.group2.parms)

    specialist1.diffbeta.moments <- betadiff.moments(specialist1.group1.moments, specialist1.group2.moments, xSample, both, specialist1=T)
    specialist2.diffbeta.moments <- betadiff.moments(specialist2.group1.moments, specialist2.group2.moments, xSample, both, specialist1=F)

    # Below two lines use rescaled (0-1) moments
    specialist1.diffbeta.parms <- beta.parms.from.moments((specialist1.diffbeta.moments$mean+1)/2, specialist1.diffbeta.moments$var/4)
    specialist2.diffbeta.parms <- beta.parms.from.moments((specialist2.diffbeta.moments$mean+1)/2, specialist2.diffbeta.moments$var/4)

    list(f=specialist1.diffbeta.moments$f, 
         specialist1=list(alpha=specialist1.diffbeta.parms$alpha, beta=specialist1.diffbeta.parms$beta),
         specialist2=list(alpha=specialist2.diffbeta.parms$alpha, beta=specialist2.diffbeta.parms$beta),
         rnd=xSample$rnd) 
  } # end of diff.moments


  marginal.xprob <- function(n, prior1, prior2, 
                             clinical.prior=list(), prior1.mixture.wt=0.5, gr=1, both=F)
  {
    # n : length 1
    # specialist(12).prior <- list(alpha:2, beta:2)

    if (!.ss.cons.defined.list(clinical.prior))
    {
      alphas <- c(prior1$alpha[gr], prior2$alpha[gr])
      betas  <- c(prior1$beta[gr],  prior2$beta[gr])
    }
    else
    {
      alphas <- clinical.prior$alpha[gr]
      betas  <- clinical.prior$beta[gr]
    }

    n.elem <- length(alphas)
    log.pr <- matrix(NA, nrow=n, ncol=n.elem)
    log.pr0 <- matrix(NA, nrow=1, ncol=n.elem)

    x <- 1:n
    for (g in 1:n.elem)
    {
      log.pr0[g] <- sum(lgamma(c(n+betas[g], alphas[g]+betas[g], n+alphas[g]+betas[g], betas[g]))*c(1,1,-1,-1))
      log.pr[,g] <- log(n-x+1) + log(alphas[g]+x-1) - log(x) - log(n-x+betas[g]) 
    }

    log.pr <- rbind(log.pr0, log.pr)
    log.pr <- apply(log.pr,2,cumsum)
    pr <- exp(log.pr)
    
    if (both)
    {
      out <- list(pr.specialists=pr)
    }
    else
    {
      out <- list()
    }

    if(n.elem == 2) pr <- pr%*%matrix(c(0,1)+c(1,-1)*prior1.mixture.wt,nrow=2,ncol=1)
    pr <- as.vector(pr)
    out$pr <- pr
    
    out
  } # end of marginal.xprob


  marginal.xprobs <- function(n, prior1, prior2,
    clinical.prior=list(), prior1.mixture.wt=0.5, both=F)
  {
    # n : length 2
    # specialist(12).prior <- list(alpha:2, beta:2)

    gr1 <- marginal.xprob(n[1], prior1, prior2, clinical.prior, prior1.mixture.wt, gr=1, both=both)
    gr2 <- marginal.xprob(n[2], prior1, prior2, clinical.prior, prior1.mixture.wt, gr=2, both=both)
    list(gr1=gr1, gr2=gr2)
  } # end of marginal.xprobs
  
  
  table.1D <- function(x1, x2, as.list=F, as.prob=T)
  {
    x1.x2 <- paste(x1, x2, sep=';')
    res <- table(x1.x2)
    
    if (as.prob) res <- res/sum(res)
    
    if (as.list)
    {
      x1.x2 <- matrix(as.integer(unlist(strsplit(names(res), ';'))), ncol=2, byrow=T)
      res <- list(x1=x1.x2[,1], x2=x1.x2[,2], f=as.numeric(res))
    }

    res
  } # end of table.1D
  
  
  # --- Start function ---------------------------------------------------------

  pr.x <- marginal.xprobs(n, prior2, prior1, clinical.prior, prior1.mixture.wt, both)
    
  # Sample (x1, x2) values

  if (is.na(sim.size) | prod(n+1) <= sim.size)
  {
    if (both)
    {
      xSample <- list(pr1=as.vector(pr.x$gr1$pr.specialists), pr2=as.vector(pr.x$gr2$pr.specialists), rnd=F)
    }
    else
    {
      xSample <- list(pr1=pr.x$gr1$pr, pr2=pr.x$gr2$pr, rnd=F)
    }
    
    out <- xSample
  }
  else
  {
    if (both)
    {
      # Sample values from specialist1 marginal distrn
      specialist <- 1
      p1 <- pr.x$gr1$pr.specialists[,specialist]
      p2 <- pr.x$gr2$pr.specialists[,specialist]
      x1 <- sample(seq(along=p1)-1, sim.size, replace=T, prob=p1)
      x2 <- sample(seq(along=p2)-1, sim.size, replace=T, prob=p2)
      f.specialist1 <- table.1D(x1, x2)
      
      # Sample values from specialist2 marginal distrn
      specialist <- 2
      p1 <- pr.x$gr1$pr.specialists[,specialist]
      p2 <- pr.x$gr2$pr.specialists[,specialist]
      x1 <- sample(seq(along=p1)-1, sim.size, replace=T, prob=p1)
      x2 <- sample(seq(along=p2)-1, sim.size, replace=T, prob=p2)
      f.specialist2 <- table.1D(x1, x2)
      
      # Merge f from both specialists
      f <- combined.tables(f.specialist1, f.specialist2)
      xSample <- list(x1=f$x1, x2=f$x2, f=f$f, rnd=T)
    }
    else
    {
      x1 <- sample(seq(along=pr.x$gr1$pr)-1, sim.size, replace=T, prob=pr.x$gr1$pr)
      x2 <- sample(seq(along=pr.x$gr2$pr)-1, sim.size, replace=T, prob=pr.x$gr2$pr)

      f <- table.1D(x1, x2, as.list=T)
      xSample <- list(x1=f$x1, x2=f$x2, f=f$f, rnd=T)
    }
    
    out <- diff.moments(n, xSample, prior2, prior1, both)
    # dimensions: f specialist1=list(alpha, beta) specialist2=list(alpha, beta)
    # if both = T, then f has two columns
    # if both = F, then f is a vector --- with same length as specialist(1|2)$(alpha|beta)
  }
  
  
  out
}
.ss.cons.2binom.q <-
function(quantiles, accepted.pdiff, prior1, prior2, 
                                               n.start, n.max, next.n=.ss.mixed.nextn, sim.size, 
                                               clinical.prior=list(), prior1.mixture.wt=0.5,
                                               target, both=F, return.worst=F, return.prob=F, epsilon=1e-8, n2.n1.ratio=1, mcs=3, min.for.possible.return=2^ceiling(1.5*mcs))
{
  # prior1, prior2 and clinical.prior must be lists with dimensions alpha & beta
  
  increasing.outcome.with.n <- return.prob
        
  if (!is.loaded('BinomConsensus')) 
  {
    path <- "c:/users/patrick.belisle/My Documents/Home/SampleSize/ConsensusBased/binom/dll"
    file.name <- "ConsensusBinomial"
    Running.on.64Bytes <- length(grep("64", R.Version()$arch)) > 0
    file.suffx <- character(0)
    if (!Running.on.64Bytes) file.suffx <- "-32bytes"
    dll <- paste(c(path, "/", file.name, file.suffx, ".dll"), collapse="")
    dyn.load(dll)
  }
  
  
  if (length(quantiles) > 1) quantiles <- sort(unique(quantiles))
  m.quantiles <- length(quantiles)
  quantiles0 <- quantiles
    

  # Initial values

  n1 <- min(n.start, n.max)
  step0 <- max(ceiling(n1/100), 10) # Initial step
  outcome <- numeric(0)
  n.visited <- numeric(0)
  estimated.from.sampling <- logical(0)

  out <- list(continue=T, target=target, increasing.outcome.with.n=increasing.outcome.with.n, step0=step0, n.max=n.max, mcs=mcs, min.for.possible.return=min.for.possible.return)
  prior.alphas <- c(prior1$alpha, prior2$alpha)
  prior.betas  <- c(prior1$beta,  prior2$beta)


  while (out$continue)
  {
    n <- ceiling(n1*c(1, n2.n1.ratio))
    
    post.moments <- .ss.cons.2binom.post.moments(n, prior1, prior2,
      clinical.prior, prior1.mixture.wt, sim.size, both)
     
    if (post.moments$rnd)
    { 
      alphas <- c(post.moments$specialist1$alpha, post.moments$specialist2$alpha)
      betas  <- c(post.moments$specialist1$beta,  post.moments$specialist2$beta)
      alphas.len <- length(alphas)
    
      quantiles <- quantiles0
      if (m.quantiles > 1) quantiles <- rep(quantiles, rep(alphas.len, m.quantiles))
      quantiles <- 2*qbeta(quantiles, alphas, betas) # multiplied by 2 to bring to -1/1 scale   
      is.specialist1.quantile <- rep(c(T,F), rep(alphas.len/2, 2))
      quantiles.diff <- abs(quantiles[!is.specialist1.quantile] - quantiles[is.specialist1.quantile])
      if (m.quantiles > 1)
      {
        quantiles.diff <- matrix(quantiles.diff, ncol=m.quantiles)
        quantiles.diff <- apply(quantiles.diff, 1, max) 
      }

      tmp <- .ss.cons.2binom.outcome(accepted.pdiff, quantiles.diff, post.moments$f, return.worst, return.prob, increasing.outcome.with.n)
    }
    else
    {
      tmp <- .C('BetaDiff4NonRnd', todo=as.integer(2), lz=m.quantiles, z=as.double(quantiles0), n, as.integer(both), as.double(accepted.pdiff), as.double(prior.alphas), as.double(prior.betas),
                                   as.double(post.moments$pr1), as.double(post.moments$pr2), as.integer(return.worst), as.integer(return.prob), out=double(1))  
      tmp <- tmp$out
    }   
    
    outcome <- c(tmp, outcome)
    n.visited <- c(n1, n.visited)
    estimated.from.sampling <- c(post.moments$rnd, estimated.from.sampling)

    out$outcome <- outcome
    out$n.visited <- n.visited
    out$estimated.from.sampling <- estimated.from.sampling

    nextn <- next.n(out, sim.size)
    out$continue <- nextn$continue
    n1 <- nextn$n
  }
  
  n <- ceiling(n1*c(1, n2.n1.ratio))

  list(n=n, n.visited=rev(out$n.visited), outcome=rev(out$outcome), estimated.from.sampling=rev(out$estimated.from.sampling))
}
.ss.cons.2binom.worst <-
function(accepted.pdiff, prior1, prior2,
                                                                    z, n.start, n.max, next.n=.ss.nextn4nonrndoutcomes, n2.n1.ratio=1, todo=0)
{
  # prior1, prior2 amd clinical.prior must be lists with dimensions alpha & beta

  increasing.outcome.with.n <- F

  if (!is.loaded('BinomConsensus'))
  {
    path <- "c:/users/patrick.belisle/My Documents/Home/SampleSize/ConsensusBased/binom/dll"
    file.name <- "ConsensusBinomial"
    Running.on.64Bytes <- length(grep("64", R.Version()$arch)) > 0
    file.suffx <- character(0)
    if (!Running.on.64Bytes) file.suffx <- "-32bytes"
    dll <- paste(c(path, "/", file.name, file.suffx, ".dll"), collapse="")
    dyn.load(dll)
  }

  # Initial values

  n1 <- min(n.start, n.max)
  step0 <- max(ceiling(n1/100), 10) # Initial step
  outcome <- numeric(0)
  n.visited <- numeric(0)

  out <- list(continue=T, target=accepted.pdiff, increasing.outcome.with.n=increasing.outcome.with.n, step0=step0, n.max=n.max)
  prior.alphas <- c(prior1$alpha, prior2$alpha)
  prior.betas  <- c(prior1$beta,  prior2$beta)


  while (out$continue)
  {
    n <- ceiling(n1*c(1, n2.n1.ratio))

    tmp <- .C('WorstOutcome', as.integer(n), length(z), as.double(z), as.double(prior.alphas), as.double(prior.betas), as.integer(todo), out=double(1))
    tmp <- tmp$out

    outcome <- c(tmp, outcome)
    n.visited <- c(n1, n.visited)

    out$outcome <- outcome
    out$n.visited <- n.visited

    nextn <- next.n(out)
    out$continue <- nextn$continue
    n1 <- nextn$n
  }

  n <- ceiling(n1*c(1, n2.n1.ratio))

  list(n=n, n.visited=rev(out$n.visited), outcome=rev(out$outcome))
}
.ss.cons.defined.list <-
function(mylist){ifelse(length(mylist) == 0, F, any(unlist(lapply(mylist, length)) > 0))}
.ss.mixed.nextn <-
function(mylist, sim.size)
{
  if (is.na(sim.size) | all(!mylist$estimated.from.sampling[seq(mylist$mcs+1)], na.rm=T))
  {
    out <- .ss.nextn4nonrndoutcomes(mylist)
  }
  else
  {
    out <- .ss.bsearch(mylist)
  }
  
  out
}
.ss.nextn4nonrndoutcomes <-
function(mylist)
{
  # Function used to perform the bisectional search

  ##################################################################
  # mylist: consists in a list of the following arguments:
  # -------
  #
  # n.visited
  # outcome
  # target
  # step0
  # increasing.outcome.with.n
  # n.max
  #
  ##################################################################

  continue <- T

  sufficient.n <- (mylist$increasing.outcome.with.n & mylist$outcome >= mylist$target) | (!mylist$increasing.outcome.with.n & mylist$outcome <= mylist$target)
  n.visited <- mylist$n.visited

  if (all(sufficient.n))
  {
    n.visited <- sort(n.visited)

    if (n.visited[1] == 0)
    {
      n <- 0
      continue <- F
    }
    else
    {
      if (length(n.visited) == 1)
      {
        n <- max(n.visited - mylist$step0, 0)
      }
      else
      {
        n <- max(n.visited[1] - 2*diff(n.visited[1:2]), 0)
      }
    }
  }
  else if (all(!sufficient.n))
  {
    n.visited <- rev(sort(n.visited))

    if (n.visited[1] == mylist$n.max)
    {
      n <- Inf
      continue <- F
    }
    else
    {
      if (length(n.visited) == 1)
      {
        n <- n.visited + mylist$step0
      }
      else
      {
        n <- n.visited[1] + 2 * (n.visited[1]-n.visited[2])
      }

      n.visited <- min(n.visited, mylist$n.max)
    }
  }
  else
  {
    smallest.sufficient.n  <- min(n.visited[sufficient.n])
    largest.insufficient.n <- max(n.visited[!sufficient.n])

    if ((smallest.sufficient.n-largest.insufficient.n) == 1)
    {
      n <- smallest.sufficient.n
      continue <- F
    }
    else
    {
      n <- floor((smallest.sufficient.n + largest.insufficient.n)/2)
    }
  }
  
  if (n > mylist$n.max)
  {
    n <- Inf
    continue <- F
  }

  # If continue=F, then n indicates the optimal sample size found

  list(n=n, continue=continue)
}



