\name{ss.cons.2binom.prob.cdf}
\alias{ss.cons.2binom.prob.cdf}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{  Plot visited sample sizes vs outcome}
\description{  This function plots the visited sample sizes (along the search for optimal sample size) vs the calculated outcome.}
\usage{
ss.cons.2binom.prob.cdf(cdf.points, accepted.cdf.diff, prior1, prior2, prior1.mixture.wt = 0.5, prob = 0.5, n2.n1.ratio = 1, n.start = 1000, n.max = 1e+05, sim.size = 10000, max.cons.steps.same.dir = 3)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{cdf.points}{
One or more points at which the two cumultative posterior densities are to be compared.
}
  \item{accepted.cdf.diff}{
The accepted difference between the two cumultative posterior densities; any difference below this value is considered as meeting the consensus criterion.
}
  \item{prior1}{
Prior distribution \emph{#1} parameters. (See \emph{Details} section for more.)
}
  \item{prior2}{
Prior distribution \emph{#2} parameters. (See \emph{Details} section for more.)
}
  \item{prior1.mixture.wt}{
Clinical prior distibution --- used to generate the data --- is a mixture of the two prior distributions, with weight \emph{prior1.mixture.wt} assigned to \emph{prior1} and \emph{1-prior1.mixture.wt} to \emph{prior2}.
}
  \item{prob}{
The probability (in terms of the preposterior distribution of the data) with which the consensus criterion must be met.
}
  \item{n2.n1.ratio}{
The desired ratio of the sample sizes from the two groups. Default value is 1.
}
  \item{n.start}{
Initial sample size used in the search for optimal sample size.
}
  \item{n.max}{
Maximum sample size allowed in the search for optimal sample size.
}
  \item{sim.size}{
The number of \bold{x} values to be sampled in order to assess consensus at each sample size visited in the march towards the optimal sample size.
}
  \item{max.cons.steps.same.dir}{
The Maximum number of Consecutive Steps allowed in the same direction in the march towards the optimal sample size, before the result for the next upper/lower bound is cross-checked. In our experience, max.cons.steps.same.dir = 3 is a good choice.
}
}
\details{
  Prior distribution (\code{prior1} and \code{prior2}) must be specified through a list with parameters \code{alpha} and \code{beta} --- both of length 2 ---,
  respectively, the first and second parameters of the Beta distribution for the two binomial proportions.
}
\value{  A figure.}
\references{
  Lawrence Joseph and Patrick Belisle\cr
  Bayesian consensus-based sample size criteria for binomial proportions\cr
  Statistics in Medicine; 2019\cr
}
\author{Lawrence Joseph \email{lawrence.joseph@mcgill.ca} and Patrick Belisle}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{ss.plot}}, \code{\link{ss.cons.2binom.prob.cdf.bothmarg}}, \code{\link{ss.cons.2binom.prob.cdf.mymarg}},
   \code{\link{ss.cons.2binom.avg.cdf}}, \code{\link{ss.cons.2binom.avg.cdf.bothmarg}},
   \code{\link{ss.cons.2binom.avg.cdf.mymarg}}, \code{\link{ss.cons.2binom.worst.cdf}},
   \code{\link{ss.cons.2binom.prob.hpdlimits}}, \code{\link{ss.cons.2binom.prob.hpdlimits.bothmarg}},
   \code{\link{ss.cons.2binom.prob.hpdlimits.mymarg}}, \code{\link{ss.cons.2binom.avg.hpdlimits}},
   \code{\link{ss.cons.2binom.avg.hpdlimits.bothmarg}}, \code{\link{ss.cons.2binom.avg.hpdlimits.mymarg}},
   \code{\link{ss.cons.2binom.worst.hpdlimits}}, \code{\link{ss.cons.2binom.prob.q}},
   \code{\link{ss.cons.2binom.prob.q.bothmarg}}, \code{\link{ss.cons.2binom.prob.q.mymarg}},
   \code{\link{ss.cons.2binom.avg.q}}, \code{\link{ss.cons.2binom.avg.q.bothmarg}},
   \code{\link{ss.cons.2binom.avg.q.mymarg}}, \code{\link{ss.cons.2binom.worst.q}}
}
\examples{
accepted.cdf.diff <- 0.01
cdf.points <- c(0.1, 0.15)
prior1 <- list(alpha=c(194, 200), beta=c(47, 20))
prior2    <- list(alpha=c(250, 150), beta=c(30, 50))
z <- ss.cons.2binom.prob.cdf(cdf.points, accepted.cdf.diff, prior1, prior2, prob=0.8)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
