\name{ss.plot}
\alias{ss.plot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{  Plot visited sample sizes vs outcome}
\description{  This function plots the visited sample sizes (along the search for optimal sample size) vs the calculated outcome.}
\usage{
ss.plot(ss.out, zero = 0.1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{ss.out}{
The output of a CBSS sample size function.
}
  \item{zero}{
An alternative value for \emph{n} in the plotting of \emph{log(n)} when \emph{n = 0}.
}
\item{show.fit}{
Whether or not a tentative fit curve will be displayed.
}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{  A figure.}
\references{
  Lawrence Joseph and Patrick Belisle\cr
  Bayesian consensus-based sample size criteria for binomial proportions\cr
  Statistics in Medicine; 2019\cr
}
\author{Lawrence Joseph \email{lawrence.joseph@mcgill.ca} and Patrick Belisle}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{ss.cons.2binom.prob.hpdlimits}}, \code{\link{ss.cons.2binom.prob.hpdlimits.bothmarg}},
   \code{\link{ss.cons.2binom.prob.hpdlimits.mymarg}}, \code{\link{ss.cons.2binom.avg.hpdlimits}},
   \code{\link{ss.cons.2binom.avg.hpdlimits.bothmarg}}, \code{\link{ss.cons.2binom.avg.hpdlimits.mymarg}},
   \code{\link{ss.cons.2binom.worst.hpdlimits}}, \code{\link{ss.cons.2binom.prob.cdf}},
   \code{\link{ss.cons.2binom.prob.cdf.bothmarg}}, \code{\link{ss.cons.2binom.prob.cdf.mymarg}},
   \code{\link{ss.cons.2binom.avg.cdf}}, \code{\link{ss.cons.2binom.avg.cdf.bothmarg}},
   \code{\link{ss.cons.2binom.avg.cdf.mymarg}}, \code{\link{ss.cons.2binom.worst.cdf}},
   \code{\link{ss.cons.2binom.prob.q}}, \code{\link{ss.cons.2binom.prob.q.bothmarg}},
   \code{\link{ss.cons.2binom.prob.q.mymarg}}, \code{\link{ss.cons.2binom.avg.q}},
   \code{\link{ss.cons.2binom.avg.q.bothmarg}}, \code{\link{ss.cons.2binom.avg.q.mymarg}},
   \code{\link{ss.cons.2binom.worst.q}}
}
\examples{
accepted.pdiff <- 0.01
prior1 <- list(alpha=c(194, 200), beta=c(47, 20))
prior2    <- list(alpha=c(250, 150), beta=c(30, 50))
z <- ss.cons.2binom.avg.hpdlimits(accepted.pdiff, prior1, prior2)
ss.plot(z)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
