ss.cons.norm.avg.cdf.mymarg <-
function(cdf.points, accepted.cdf.diff, 
                                                  prior1, prior2, clinical.prior,
                                                  n.start=1000, n.max=100000, sim.size=50000, max.cons.steps.same.dir=3)
{  
  # prior1, prior2 and clinical.prior must be lists with dimensions mu0, n0, prec.shape and prec.rate
  tmp <- .ss.cons.norm.check.list(prior1, "prior1")
  tmp <- .ss.cons.norm.check.list(prior2, "prior2")
  tmp <- .ss.cons.norm.check.list(clinical.prior, "clinical.prior")

  
  out <- .ss.cons.norm.cdf(cdf.points, accepted.cdf.diff, 
                                      prior1, prior2, 
                                      sim.size, n.start, n.max, max.cons.steps.same.dir,
                                      clinical.prior=clinical.prior)
    
  out <- c(out, list(cdf.points=cdf.points, accepted.cdf.diff=accepted.cdf.diff, 
                     prior1=prior1, prior2=prior2, clinical.prior=clinical.prior,
                     n.start=n.start, n.max=n.max, sim.size=sim.size,
                     max.cons.steps.same.dir=max.cons.steps.same.dir, exact.results=F))
  return(out)
}
