ss.cons.norm.avg.q <-
function(quantiles, accepted.diff, 
                                                 prior1, prior2, prior1.mixture.wt=0.5, 
                                                 n.start=1000, n.max=100000, sim.size=50000, max.cons.steps.same.dir=3)
{
  # prior1 and prior2 must be lists with dimensions mu0, n0, prec.shape and prec.rate
  tmp <- .ss.cons.norm.check.list(prior1, "prior1")
  tmp <- .ss.cons.norm.check.list(prior2, "prior2")
  

  out <- .ss.cons.norm.q(quantiles, accepted.diff, prior1, prior2,
                                           sim.size, n.start, n.max, max.cons.steps.same.dir, prior1.mixture.wt=prior1.mixture.wt)


  out <- c(out, list(quantiles=quantiles, accepted.diff=accepted.diff, 
                     prior1=prior1, prior2=prior2, prior1.mixture.wt=prior1.mixture.wt, 
                     n.start=n.start, n.max=n.max, sim.size=sim.size, max.cons.steps.same.dir=max.cons.steps.same.dir, exact.results=F))
  return(out)
}
