ss.cons.norm.knownvar.avg.cdf.bothmarg <-
function(cdf.points, accepted.cdf.diff, prec,
                                                             prior1, prior2, 
                                                             n.start=1000, n.max=100000, convexity.check.sim.size=10000)
{
  # Both prior2 and prior1 must be lists, with dimensions mu0 and prec0
  tmp <- .ss.cons.norm.check.list(prior1, "prior1", T)
  tmp <- .ss.cons.norm.check.list(prior2, "prior2", T)

    
  out <- .ss.cons.norm.knownvar.avg.cdf(cdf.points, accepted.cdf.diff, prec,
                                                   prior1, prior2, n.start, n.max,
                                                   both=T, convexity.check.sim.size=convexity.check.sim.size)

  out <- c(out, list(cdf.points=cdf.points, accepted.cdf.diff=accepted.cdf.diff, prec=prec, prior1=prior1, prior2=prior2,
                     n.start=n.start, n.max=n.max, convexity.check.sim.size=convexity.check.sim.size, exact.results=T))

  if (out$convexity.check.success.rate < 1) warning("Our sample size calculations are based on a log-convexity assumption for  p_nj(x.bar).\n  While we have never come across an example that violates this assumption, it appears that you may have found a counter-example.\n  Could you please send us your full problem description?")
  return(out)
}
