ss.cons.norm.knownvar.avg.hpdlimits <-
function(accepted.diff, prec, 
                                                          prior1, prior2, prior1.mixture.wt=0.5, 
                                                          level=0.95, n.max=100000)
{                                                                      
  # Both prior2 and prior1 must be lists, with dimensions mu0 and prec0
  tmp <- .ss.cons.norm.check.list(prior1, "prior1", T)
  tmp <- .ss.cons.norm.check.list(prior2, "prior2", T)


  if (prior1$prec0 == prior2$prec0)
  {
    n <- ceiling((abs(prior1$mu0-prior2$mu0)/accepted.diff-1)*prior1$prec0/prec)
    n <- max(n, 0)
    out <- list(n=n)
  }
  else
  {
    out <- .ss.cons.norm.knownvar.avg.hpdlimits(accepted.diff, prec,
                                                          prior1, prior2, 
                                                          level, n.max=n.max, prior1.mixture.wt=prior1.mixture.wt)
  }
  

  out <- c(out, list(accepted.diff=accepted.diff, prec=prec, prior1=prior1, prior2=prior2,
                     prior1.mixture.wt=prior1.mixture.wt, level=level, n.max=n.max, exact.results=T))

  return(out)
}
