ss.cons.norm.knownvar.prob.cdf <-
function(cdf.points, accepted.cdf.diff, prec,
                                                      prior1, prior2, prior1.mixture.wt=0.5, 
                                                      prob=0.5, n.start=1000, n.max=100000, epsilon=1e-8)
{
  # prior1 and prior2 must be lists with dimensions mu0 and prec0
  tmp <- .ss.cons.norm.check.list(prior1, "prior1", T)
  tmp <- .ss.cons.norm.check.list(prior2, "prior2", T)

  
  out <- .ss.cons.norm.knownvar.prob.cdf(cdf.points, accepted.cdf.diff, prec, prior1, prior2, n.start, n.max, prob, prior1.mixture.wt=prior1.mixture.wt, epsilon=epsilon)

  out <- c(out, list(cdf.points=cdf.points, accepted.cdf.diff=accepted.cdf.diff, prec=prec,
                     prior1=prior1, prior2=prior2, prior1.mixture.wt=prior1.mixture.wt,
                     prob=prob, n.start=n.start, n.max=n.max, epsilon=epsilon, exact.results=T))
                     
  return(out)
}
