ss.cons.norm.knownvar.prob.cdf.mymarg <-
function(cdf.points, accepted.cdf.diff, prec, 
                                                            prior1, prior2, clinical.prior, 
                                                            prob=0.5, n.start=1000, n.max=100000, epsilon=1e-8)
{
  # prior1, prior2 and clinical.prior must be lists with dimensions mu0 and prec0
  tmp <- .ss.cons.norm.check.list(prior1, "prior1", T)
  tmp <- .ss.cons.norm.check.list(prior2, "prior2", T)
  tmp <- .ss.cons.norm.check.list(clinical.prior, "clinical.prior", T)
  
  
  out <- .ss.cons.norm.knownvar.prob.cdf(cdf.points, accepted.cdf.diff, prec, prior1, prior2, n.start, n.max, prob, clinical.prior=clinical.prior, epsilon=epsilon)

  out <- c(out, list(cdf.points=cdf.points, accepted.cdf.diff=accepted.cdf.diff, prec=prec,
                     prior1=prior1, prior2=prior2, clinical.prior=clinical.prior, prob=prob,
                     n.start=n.start, n.max=n.max, epsilon=epsilon, exact.results=T))
  return(out)
}
