ss.cons.norm.knownvar.prob.q.bothmarg <-
function(quantiles, accepted.diff, prec, 
                                                                    prior1, prior2, prob=0.5, 
                                                                    n.max=100000)
{                                                                      
  # Both prior2 and prior1 must be lists, with dimensions mu0 and prec0
  tmp <- .ss.cons.norm.check.list(prior1, "prior1", T)
  tmp <- .ss.cons.norm.check.list(prior2, "prior2", T)


  if (prior1$prec0 == prior2$prec0)
  {
    n <- ceiling(pmax(0, (abs(prior1$mu0 - prior2$mu0)/accepted.diff - 1) * prior1$prec0/prec))
    out <- list(n=n)
  }
  else
  {
    out <- .ss.cons.norm.knownvar.prob.q(quantiles, accepted.diff, prec,
                                                           prior1, prior2, both=T, 
                                                           prob=prob, n.max=n.max)
  }
  

  out <- c(out, list(quantiles=quantiles, accepted.diff=accepted.diff, prec=prec, 
                     prior1=prior1, prior2=prior2, prob=prob,
                     n.max=n.max, exact.results=T))

  return(out)
}
