ss.cons.norm.knownvar.worst.cdf <-
function(cdf.points, accepted.cdf.diff, prec,
                                                       prior1, prior2, 
                                                       n.start=1000, n.max=100000)
{
  # Both prior2 and prior1 must be lists, with dimensions mu0 and prec0
  tmp <- .ss.cons.norm.check.list(prior1, "prior1", T)
  tmp <- .ss.cons.norm.check.list(prior2, "prior2", T)

                       
  mu0s     <- c(prior1$mu0, prior2$mu0)
  prec0s <- c(prior1$prec0, prior2$prec0)
  
  worst.g <- function(n, cdf.points, prec, mu0s, prec0s)
  {
    cdf.points <- rep(cdf.points, rep(2, length(cdf.points)))
    j <- seq(from=1, to=length(cdf.points), by=2)

    if (n == 0)
    {
      p <- pnorm(cdf.points, mean=mu0s, sd=1/sqrt(prec0s))
      res <- max(abs(p[j]-p[j+1]))
    }
    else
    { 
      prec.n  <- prec0s + n*prec
      a <- sqrt(prec.n)*cdf.points - sqrt(prec.n)*prec0s*mu0s/prec.n
      b <- n*prec/sqrt(prec.n)
  
      B <- b[2]/b[1]
      A <- a[j+1] - B*a[j]
      
      if (B != 1)
      {
        delta <- (2*A*B)^2 - 4*(B*B-1)*(A*A-2*log(B))
        w <- seq(along=delta)[delta>=0]
        num1 <- -2*A*B
        num1 <- num1[w]
        denom <- 2*(B*B-1) # scalar
        delta <- delta[w]
  
        zmax <- c((num1-sqrt(delta))/denom, (num1+sqrt(delta))/denom)
      }
      else
      {
        zmax <- -A/2
        w <- seq(along=A)
      }
      
      gmax <- abs(pnorm(zmax) - pnorm(A[w] + B * zmax))
  
      res <- max(gmax)
    }
    
    return(res)
  }

  
  # ~*~*~*~*~*~

  # Initial values

  n <- min(n.start, n.max)
  step0 <- max(ceiling(n/100), 10) # Initial step
  outcome <- numeric(0)
  n.visited <- numeric(0)

  out <- list(continue=T, target=accepted.cdf.diff, increasing.outcome.with.n=F, step0=step0, n.max=n.max)
 
  while (out$continue)
  {
    z <- worst.g(n, cdf.points, prec, mu0s, prec0s)

    outcome <- c(z, outcome)
    n.visited <- c(n, n.visited)

    out$outcome <- outcome
    out$n.visited <- n.visited

    nextn <- .ss.nextn4nonrndoutcomes(out)
    out$continue <- nextn$continue
    n <- nextn$n
  }  

  list(n=n, n.visited=rev(out$n.visited), outcome=rev(out$outcome),
       cdf.points=cdf.points, accepted.cdf.diff=accepted.cdf.diff, prec=prec,
       prior1=prior1, prior2=prior2, n.start=n.start, n.max=n.max, exact.results=T)
}
