\name{ss.cons.norm.avg.hpdlimits.bothmarg}
\alias{ss.cons.norm.avg.hpdlimits.bothmarg}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{  Plot visited sample sizes vs outcome}
\description{  This function plots the visited sample sizes (along the search for optimal sample size) vs the calculated outcome.}
\usage{
ss.cons.norm.avg.hpdlimits.bothmarg(accepted.diff, prior1, prior2, level = 0.95, n.start = 1000, n.max = 1e+05, sim.size = 50000, max.cons.steps.same.dir = 3)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{accepted.diff}{
The accepted difference between the two specialists' <A>; any difference below that value is ruled as consensus.
}
  \item{prior1}{
Prior distribution \emph{#1} parameters. (See \emph{Details} section for more.)
}
  \item{prior2}{
Prior distribution \emph{#2} parameters. (See \emph{Details} section for more.)
}
  \item{level}{
Coverage probability of the two HPD intervals.
}
  \item{n.start}{
Initial sample size used in the search for optimal sample size.
}
  \item{n.max}{
Maximum sample size allowed in the search for optimal sample size.
}
  \item{sim.size}{
The number of \bold{x} values to be sampled in order to assess consensus at each sample size visited in the march towards the optimal sample size.
}
  \item{max.cons.steps.same.dir}{
The Maximum number of Consecutive Steps allowed in the same direction in the march towards the optimal sample size, before the result for the next upper/lower bound is cross-checked. In our experience, max.cons.steps.same.dir = 3 is a good choice.
}
}
\details{
  Prior distributions (\code{prior1} and \code{prior2}) must be specified through a list with parameters \code{mu0}, \code{n0}, \code{prec.shape} and \code{prec.rate}
  where \code{prec.shape} and \code{prec.rate} are, respectively, the prior Gamma distribution shape and rate parameters for the unknown precision.
}
\value{  A figure.}
\references{
  Lawrence Joseph and Patrick Belisle\cr
  Bayesian consensus-based sample size criteria for binomial proportions\cr
  Statistics in Medicine; 2019\cr
}
\author{Lawrence Joseph \email{lawrence.joseph@mcgill.ca} and Patrick Belisle}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{ss.plot}}, \code{\link{ss.cons.norm.avg.hpdlimits}}, \code{\link{ss.cons.norm.avg.hpdlimits.mymarg}}, \code{\link{ss.cons.norm.knownvar.avg.hpdlimits}},
   \code{\link{ss.cons.norm.knownvar.avg.hpdlimits.bothmarg}}, \code{\link{ss.cons.norm.knownvar.avg.hpdlimits.mymarg}}, \code{\link{ss.cons.norm.knownvar.prob.hpdlimits}},
   \code{\link{ss.cons.norm.knownvar.prob.hpdlimits.bothmarg}}, \code{\link{ss.cons.norm.knownvar.prob.hpdlimits.mymarg}}, \code{\link{ss.cons.norm.prob.hpdlimits}},
   \code{\link{ss.cons.norm.prob.hpdlimits.bothmarg}}, \code{\link{ss.cons.norm.prob.hpdlimits.mymarg}}, \code{\link{ss.cons.norm.avg.cdf}},
   \code{\link{ss.cons.norm.avg.cdf.bothmarg}}, \code{\link{ss.cons.norm.avg.cdf.mymarg}}, \code{\link{ss.cons.norm.knownvar.avg.cdf}},
   \code{\link{ss.cons.norm.knownvar.avg.cdf.bothmarg}}, \code{\link{ss.cons.norm.knownvar.avg.cdf.mymarg}}, \code{\link{ss.cons.norm.knownvar.prob.cdf}},
   \code{\link{ss.cons.norm.knownvar.prob.cdf.bothmarg}}, \code{\link{ss.cons.norm.knownvar.prob.cdf.mymarg}}, \code{\link{ss.cons.norm.prob.cdf}},
   \code{\link{ss.cons.norm.prob.cdf.bothmarg}}, \code{\link{ss.cons.norm.prob.cdf.mymarg}}, \code{\link{ss.cons.norm.knownvar.worst.cdf}},
   \code{\link{ss.cons.norm.avg.q}}, \code{\link{ss.cons.norm.avg.q.bothmarg}}, \code{\link{ss.cons.norm.avg.q.mymarg}},
   \code{\link{ss.cons.norm.knownvar.avg.q}}, \code{\link{ss.cons.norm.knownvar.avg.q.bothmarg}}, \code{\link{ss.cons.norm.knownvar.avg.q.mymarg}},
   \code{\link{ss.cons.norm.knownvar.prob.q}}, \code{\link{ss.cons.norm.knownvar.prob.q.bothmarg}}, \code{\link{ss.cons.norm.knownvar.prob.q.mymarg}},
   \code{\link{ss.cons.norm.prob.q}}, \code{\link{ss.cons.norm.prob.q.bothmarg}}, \code{\link{ss.cons.norm.prob.q.mymarg}}
}
\examples{
  precision.prior <- list(shape=23.85, rate=2197.446) # Gamma prior distribution parameters for precision; sigma = 1/sqrt(precision) has 95% CI: (8, 12)
  accepted.diff <- 0.01
  prior1 <- list(mu0=15, n0=25, prec.shape=precision.prior$shape, prec.rate=precision.prior$rate)
  prior2    <- list(mu0=5,  n0=25, prec.shape=precision.prior$shape, prec.rate=precision.prior$rate)
  z <- ss.cons.norm.avg.hpdlimits.bothmarg(accepted.diff, prior1, prior2)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
