\name{ss.cons.norm.knownvar.worst.cdf}
\alias{ss.cons.norm.knownvar.worst.cdf}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{  Plot visited sample sizes vs outcome}
\description{  This function plots the visited sample sizes (along the search for optimal sample size) vs the calculated outcome.}
\usage{
ss.cons.norm.knownvar.worst.cdf(cdf.points, accepted.cdf.diff, prec, prior1, prior2, n.start = 1000, n.max = 1e+05)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{cdf.points}{
One or more points at which the two cumultative posterior densities are to be compared.
}
  \item{accepted.cdf.diff}{
The accepted difference between the two cumultative posterior densities; any difference below this value is considered as meeting the consensus criterion.
}
  \item{prec}{
The known precision (precision is defined as the reciprocal of the variance).
}
  \item{prior1}{
Prior distribution \emph{#1} parameters. (See \emph{Details} section for more.)
}
  \item{prior2}{
Prior distribution \emph{#2} parameters. (See \emph{Details} section for more.)
}
  \item{n.start}{
Initial sample size used in the search for optimal sample size.
}
  \item{n.max}{
Maximum sample size allowed in the search for optimal sample size.
}
}
\details{  Prior distribution (\code{prior1} and \code{prior2}) must be specified through a list with parameters \code{mu0} and \code{prec0}.}
\value{  A figure.}
\references{
  Lawrence Joseph and Patrick Belisle\cr
  Bayesian consensus-based sample size criteria for binomial proportions\cr
  Statistics in Medicine; 2019\cr
}
\author{Lawrence Joseph \email{lawrence.joseph@mcgill.ca} and Patrick Belisle}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{ss.plot}}, \code{\link{ss.cons.norm.avg.cdf}}, \code{\link{ss.cons.norm.avg.cdf.bothmarg}}, \code{\link{ss.cons.norm.avg.cdf.mymarg}},
   \code{\link{ss.cons.norm.knownvar.avg.cdf}}, \code{\link{ss.cons.norm.knownvar.avg.cdf.bothmarg}}, \code{\link{ss.cons.norm.knownvar.avg.cdf.mymarg}},
   \code{\link{ss.cons.norm.knownvar.prob.cdf}}, \code{\link{ss.cons.norm.knownvar.prob.cdf.bothmarg}}, \code{\link{ss.cons.norm.knownvar.prob.cdf.mymarg}},
   \code{\link{ss.cons.norm.prob.cdf}}, \code{\link{ss.cons.norm.prob.cdf.bothmarg}}, \code{\link{ss.cons.norm.prob.cdf.mymarg}}, \code{\link{ss.cons.norm.avg.hpdlimits}},
   \code{\link{ss.cons.norm.avg.hpdlimits.bothmarg}}, \code{\link{ss.cons.norm.avg.hpdlimits.mymarg}}, \code{\link{ss.cons.norm.knownvar.avg.hpdlimits}},
   \code{\link{ss.cons.norm.knownvar.avg.hpdlimits.bothmarg}}, \code{\link{ss.cons.norm.knownvar.avg.hpdlimits.mymarg}}, \code{\link{ss.cons.norm.knownvar.prob.hpdlimits}},
   \code{\link{ss.cons.norm.knownvar.prob.hpdlimits.bothmarg}}, \code{\link{ss.cons.norm.knownvar.prob.hpdlimits.mymarg}}, \code{\link{ss.cons.norm.prob.hpdlimits}},
   \code{\link{ss.cons.norm.prob.hpdlimits.bothmarg}}, \code{\link{ss.cons.norm.prob.hpdlimits.mymarg}}, \code{\link{ss.cons.norm.avg.q}},
   \code{\link{ss.cons.norm.avg.q.bothmarg}}, \code{\link{ss.cons.norm.avg.q.mymarg}}, \code{\link{ss.cons.norm.knownvar.avg.q}},
   \code{\link{ss.cons.norm.knownvar.avg.q.bothmarg}}, \code{\link{ss.cons.norm.knownvar.avg.q.mymarg}}, \code{\link{ss.cons.norm.knownvar.prob.q}},
   \code{\link{ss.cons.norm.knownvar.prob.q.bothmarg}}, \code{\link{ss.cons.norm.knownvar.prob.q.mymarg}}, \code{\link{ss.cons.norm.prob.q}},
   \code{\link{ss.cons.norm.prob.q.bothmarg}}, \code{\link{ss.cons.norm.prob.q.mymarg}}
}
\examples{
  accepted.cdf.diff <- 0.025
  cdf.points <- c(5, 10)
  prior1.known.var <- list(mu0=15, prec0=2.1)
  known.prec <- 2
  prior2.known.var    <- list(mu0=5,  prec0=2.2)
  z <- ss.cons.norm.knownvar.worst.cdf(cdf.points, accepted.cdf.diff, known.prec, prior1.known.var, prior2.known.var)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
