\name{ss.plot}
\alias{ss.plot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{  Plot visited sample sizes vs outcome}
\description{  This function plots the visited sample sizes (along the search for optimal sample size) vs the calculated outcome.}
\usage{
ss.plot(ss.out, zero = 0.1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{ss.out}{
The output of a CBSS sample size function.
}
  \item{zero}{
An alternative value for \emph{n} in the plotting of \emph{log(n)} when \emph{n = 0}.
}
\item{show.fit}{
Whether or not a tentative fit curve will be displayed.
}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{  A figure.}
\references{
  Lawrence Joseph and Patrick Belisle\cr
  Bayesian consensus-based sample size criteria for binomial proportions\cr
  Statistics in Medicine; 2019\cr
}
\author{Lawrence Joseph \email{lawrence.joseph@mcgill.ca} and Patrick Belisle}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{ss.cons.norm.knownvar.prob.hpdlimits}}, \code{\link{ss.cons.norm.knownvar.prob.hpdlimits.bothmarg}}, \code{\link{ss.cons.norm.knownvar.prob.hpdlimits.mymarg}},
   \code{\link{ss.cons.norm.prob.hpdlimits}}, \code{\link{ss.cons.norm.prob.hpdlimits.bothmarg}}, \code{\link{ss.cons.norm.prob.hpdlimits.mymarg}},
   \code{\link{ss.cons.norm.avg.hpdlimits}}, \code{\link{ss.cons.norm.avg.hpdlimits.bothmarg}}, \code{\link{ss.cons.norm.avg.hpdlimits.mymarg}},
   \code{\link{ss.cons.norm.knownvar.avg.hpdlimits}}, \code{\link{ss.cons.norm.knownvar.avg.hpdlimits.bothmarg}}, \code{\link{ss.cons.norm.knownvar.avg.hpdlimits.mymarg}},
   \code{\link{ss.cons.norm.knownvar.prob.cdf}}, \code{\link{ss.cons.norm.knownvar.prob.cdf.bothmarg}}, \code{\link{ss.cons.norm.knownvar.prob.cdf.mymarg}},
   \code{\link{ss.cons.norm.prob.cdf}}, \code{\link{ss.cons.norm.prob.cdf.bothmarg}}, \code{\link{ss.cons.norm.prob.cdf.mymarg}}, \code{\link{ss.cons.norm.avg.cdf}},
   \code{\link{ss.cons.norm.avg.cdf.bothmarg}}, \code{\link{ss.cons.norm.avg.cdf.mymarg}}, \code{\link{ss.cons.norm.knownvar.avg.cdf}},
   \code{\link{ss.cons.norm.knownvar.avg.cdf.bothmarg}}, \code{\link{ss.cons.norm.knownvar.avg.cdf.mymarg}}, \code{\link{ss.cons.norm.knownvar.worst.cdf}},
   \code{\link{ss.cons.norm.knownvar.prob.q}}, \code{\link{ss.cons.norm.knownvar.prob.q.bothmarg}}, \code{\link{ss.cons.norm.knownvar.prob.q.mymarg}},
   \code{\link{ss.cons.norm.prob.q}}, \code{\link{ss.cons.norm.prob.q.bothmarg}}, \code{\link{ss.cons.norm.prob.q.mymarg}},
   \code{\link{ss.cons.norm.avg.q}}, \code{\link{ss.cons.norm.avg.q.bothmarg}}, \code{\link{ss.cons.norm.avg.q.mymarg}},
   \code{\link{ss.cons.norm.knownvar.avg.q}}, \code{\link{ss.cons.norm.knownvar.avg.q.bothmarg}}, \code{\link{ss.cons.norm.knownvar.avg.q.mymarg}}
}
\examples{
gamma.parms <- list(shape=23.85, rate=2197.446) # sigma 95% CI: (8, 12)
accepted.diff <- 0.01
prior1 <- list(mu0=15, n0=25, prec.shape=gamma.parms$shape, prec.rate=gamma.parms$rate)
prior2    <- list(mu0=5,  n0=25, prec.shape=gamma.parms$shape, prec.rate=gamma.parms$rate)
z <- ss.cons.norm.avg.hpdlimits(accepted.diff, prior1, prior2)
ss.plot(z)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
