prop.plot <-
function(prop.out)
{
  plot(prop.out$steps$n, prop.out$steps$outcome, xlab='Sample size', ylab='Outcome')
  target <- ifelse(prop.out$length.is.fixed, prop.out$level, prop.out$len)
  abline(h=target, col='grey', lty=3)
  abline(v=prop.out$n, col='orange')

  points(prop.out$n, par("usr")[3], pch=17, col='purple')
  optss.txt <- paste(c('n=',prop.out$n), collapse="")
  pos <- ifelse(prop.out$n>mean(par('usr')[1:2]), 2, 3)
  text(prop.out$n, par('usr')[3] + strheight('m'), optss.txt, pos=pos, col='purple', cex=0.8)
}
