\name{prop.mblwoc}
\alias{prop.mblwoc}
\title{Bayesian sample size determination for a binomial proportion using the Mixed Bayesian/Likelihood Worst Outcome Criterion} 
\description{The function \code{prop.mblwoc} uses a mixed Bayesian/likelihood approach to determine conservative sample size for a single binomial proportion,
in the sense that the desired posterior credible interval coverage and length are guaranteed over all possible data sets.}
\usage{
prop.mblwoc(len, alpha, beta, level = 0.95, exact = TRUE, sim.size = 1000,
  precision = 1e-06, mcs = 3)
}
\arguments{
  \item{len}{The fixed length of the posterior credible interval for the proportion under study}
  \item{alpha}{First prior parameter of the Beta density for the binomial proportion}
  \item{beta}{Second prior parameter of the Beta density for the binomial proportion}
  \item{level}{The desired average coverage probability of the posterior credible interval (e.g., 0.95)}
  \item{exact}{logical. Whether or not average length of the posterior credible interval for the proportion under study is calculated over the exact marginal distribution of data.\cr
     When exact = FALSE, average length is estimated over a random sample of possible data.}
  \item{sim.size}{Number of data points sampled (from marginal distribution) used in average length estimation.\cr Irrelevant if exact = TRUE.}
  \item{precision}{Numerical precision to reach in the calculation of posterior credible intervals.}
  \item{mcs}{The Maximum number of Consecutive Steps allowed in the same direction in the march towards the optimal sample size, before the result for the next upper/lower bound is cross-checked. In our experience, mcs = 3 is a good choice.\cr
  Irrelevant if exact = TRUE.}
}
\details{Assume that a sample from a population will be collected in order to estimate a binomial proportion.
Assume that the proportion has prior information in the form of a Beta(\emph{alpha}, \emph{beta}) density.
The function \code{prop.mblwoc} returns the required sample size to attain the
desired length \emph{len} for the posterior credible interval of fixed coverage probability \emph{level}
for the unknown proportion.
\cr\cr
This function uses a Mixed Bayesian/Likelihood (MBL) approach. 
MBL approaches use the prior information to derive the predictive distribution of the data, but use only the likelihood function for final inferences.
This approach is intended to satisfy investigators who recognize that prior information is important for planning purposes but prefer to base final inferences only on the data.}
\value{
\item{n}{Optimal sample size.}
\item{steps$n}{Sample sizes visited in the march towards optimal sample size.}
\item{steps$outcome}{Smallest coverage of HPD intervals for corresponding sample sizes found in \code{steps$n}.}
\item{length.is.fixed}{A logical variable indicating whether HPD intervals were of fixed length or fixed coverage (useful when plotting results with \code{prop.plot}).}
\item{MBL}{A logical variable indicating whether or not the result was based on a Mixed Bayesian/Likelihood approach (useful for future reference).}
Other output dimensions are copies of input arguments.
}
\references{Lawrence Joseph, David B. Wolfson and Roxane du Berger\cr
Sample size calculations for binomial proportions via highest posterior density intervals\cr
The Statistician, 1995;44(2):143-154.\cr\cr
Joseph L, du Berger R, and Belisle P.\cr
Bayesian and mixed Bayesian/likelihood criteria for sample size determination\cr
Statistics in Medicine 1997;16(7):769-781.}
\author{Lawrence Joseph \email{lawrence.joseph@mcgill.ca}, David B. Wolfson, Roxane du Berger and Patrick Belisle}
\seealso{
  \code{\link{prop.acc}},
  \code{\link{prop.alc}}, 
  \code{\link{prop.modwoc}}, 
  \code{\link{prop.woc}}, 
  \code{\link{prop.mblacc}}, 
  \code{\link{prop.mblalc}}, 
  \code{\link{prop.mblmodwoc}},
  \code{\link{prop.plot}}
}
\examples{prop.mblwoc(len=0.05, alpha=2, beta=1.5, level=0.95)}
\keyword{design}
\concept{Bayesian sample size}
\concept{Binomial proportion}
\concept{Mixed Bayesian/Likelihood Worst Outcome Criterion MBLWOC}
