\name{prop.plot}
\alias{prop.plot}
\title{Plotting outcome versus sample size for sample sizes visited in the march towards optimal sample size in SampleSizeBinomial functions}
\description{The function \code{prop.plot} plots the outcome (e.g. average HPD interval lengths or coverages) versus sample size in the march towards optimal sample size in SampleSizeBinomial functions.}
\usage{prop.plot(prop.out)}
\arguments{
  \item{prop.out}{The output of any of \code{prop.acc}, \code{prop.alc}, \code{prop.modwoc}, \code{prop.woc}, \code{prop.mblacc}, \code{prop.mblalc}, \code{prop.mblmodwoc} or \code{prop.mblwoc}.}
}
\value{
  Draws a scatter plot of sample sizes visited in the march towards optimal sample size along with the outcome (e.g. average HPD length or coverage, whether it was exactly calculated or estimated by simulation).
  The plot will also include a vertical bar indicating the optimal sample size calculated and a horizontal bar showing the target outcome value.
}
\references{Lawrence Joseph, David B. Wolfson and Roxane du Berger\cr
Sample size calculations for binomial proportions via highest posterior density intervals\cr
The Statistician, 1995;44(2):143-154.\cr\cr
Joseph L, du Berger R, and Belisle P.\cr
Bayesian and mixed Bayesian/likelihood criteria for sample size determination\cr
Statistics in Medicine 1997;16(7):769-781.}
\author{Lawrence Joseph \email{lawrence.joseph@mcgill.ca}, David B. Wolfson, Roxane du Berger and Patrick Belisle}
\seealso{
  \code{\link{prop.acc}},
  \code{\link{prop.alc}}, 
  \code{\link{prop.modwoc}},
  \code{\link{prop.woc}},  
  \code{\link{prop.mblacc}}, 
  \code{\link{prop.mblalc}}, 
  \code{\link{prop.mblmodwoc}}, 
  \code{\link{prop.mblwoc}}
}
\examples{
  prop.out <- prop.acc(len=0.05, alpha=2, beta=1.5, level=0.95)
  prop.plot(prop.out)
}

