      PROGRAM HPDB1 
c
c*********************************************************************         
c
c                             1994-06-23 
c          SAMPLE SIZE CALCULATION FOR A BINOMIAL PARAMETER
c                            EXACT METHOD                        
c
c                1) Standard Normal Theory Based Frequentist Method
c                2) Average Coverage Criterion (ACC); 
c                3) Average Length   Criterion (ALC);
c                4) Worst   Outcome  Criterion (WOC);
c
c
c NOTE: Minimum coverage == Maximum length in (WOC);
c       We thus choose to produce results in 
c         terms of Minimum Coverage
c
c       Method described in:
c
c              Joseph,L., Wolfson,D.B. and du Berger,R.
c               Sample Size Calculations For Binomial
c         Proportions Via Highest Posterior Density Intervals,
c              The Statistician, to appear in 1995, 44(2).
c                      
c
c APPROACH TO SAMPLE SIZE SELECTION of n
c
c BOUND n such that for n \in [n_{lo},n_{up}],
c              g(n_{lo}).g(n_{up})<0
c
c FIND  for n bounded in [n_lo,n_up], 
c              select n such that
c              g(n)<=0 and g(n-1)>0, where
c
c  g(n) = -[\sum_{x=0}^n A(x) p(x) - CS]      in ACC,WOC
c  g(n) = \sum_{x}^n w'(x,n)p(x) - w          in ALC
c
c THE FOLLOWING parameters must be input
c
c Beta prior parameters a,b for the binomial parameter;
c  the mean and variance are a/(a+b) and a*b/((a+b)^2*(a+b+1))
c  respectively
c The desired HPD coverage probability CS
c The desired HPD interval length w
c The point estimate for the binomial parameter
c  fpr (used for frequentist method only)    
c
c*********************************************************************
c
c     ..Parameters..
      integer          zero,one,two,three,four
      parameter       (zero=0,one=1,two=2,three=3,four=4)

c     ..Arguments..
      integer          nl,nu,fnu,nfin,method,method(4),i
      real             t0,tarray(2)
      double precision alpha,beta,CS,w,gnl,fpr
      character*26     labem(4)
      character*25     fmt1
      character*75     fmt2
      logical          long,bracket,err 

c     ..Calling procedures..
c     READPAR                                  !input/check parameters
      integer          FRQSMP                 !frequentist sample size
c     BRACKN                        !bracket n such that g(n1).g(n2)<0
c     FINDN                                        !Sample size search
      real             DTIME                      !timer for execution

c     ..INITIALIZE

      fmt1 = '*************************'
      fmt2 = fmt1//fmt1//fmt1
      method(one) = one                                           !ACC
      method(two) = three                                         !ALC
      method(three) = two                                         !WAC
      method(four) = four                                         !WAL
      labem(one) =                         'Average Coverage Criterion'
      labem(two) =                         '  Average Length Criterion'
      labem(three) =                       '   Worst Outcome Criterion'
      labem(four) =                        'AL Worst Outcome Criterion'

c     ..READ AND CHECK INPUT PARAMETERS

      call READPAR(long,fmt2,alpha,beta,CS,w,fpr)
      long=.false.                             !output is always short

c     ..FREQUENTIST APPROACH TO SAMPLE SIZE SELECTION

      write(6,'(/4x,a)') fmt2
      fnu = FRQSMP(fpr,CS,w)
      if (fnu.lt.zero) fnu = zero
      write(6,'(/6x,a,1x,g17.11)')        'Given point estimate =',fpr
      write(6,'(8x,a,1x,i10)')         'Frequentist sample size =',fnu
      write(6,'(/4x,a/)') fmt2

      t0    = DTIME(tarray)                             !time our work

c     ..SAMPLE SIZES FOR CRITERIA ACC,ALC,WOC

c     ..BRACKET FUNCTION SUCH THAT g(nl)*g(nu)<0 and n \in [nl,nu]

      do 100 i = one,three                         !Begin all criteria

c       write(6,'(/4x,2(a,1x)/)')                    'B1SMP:',labem(i)
       write(6,'(/4x,a/)')                                    labem(i)

       if ((i.eq.two).or.(i.eq.four)) then                !for ALC,WAL
        nu = nfin
       else                                               !for ACC,WAC
        if (fnu.gt.one) then    !avoid problems
         nu = fnu
        else
         nu = 1
        endif
       endif

       call BRACKN(long,method(i),CS,w,alpha,beta,nl,nu,gnl,bracket)

       if (bracket) then      !We now have hi and lo sample size bound

        if (long) then 
         write(6,'(/6x,a)')             'Function is bracketed between'
         write(6,'(8x,a,1x,i10)')            'lower  sample size =',nl
         write(6,'(8x,a,1x,i10/)')           'upper  sample size =',nu
        endif

c     ..BEGIN SAMPLE SIZE SEARCH

        err = .false.
        if ((nu-nl).gt.one) then
         call FINDN(long,method(i),nl,nu,gnl,CS,w,alpha,beta,err,nfin)
        else
         nfin = nu
        endif
        if (err) write(6,'(/6x,a,1x)')      'Sample size is NOT found'

       else                         !sample size search is not bounded

        if (nu.eq.zero) then
         write(6,'(/6x,a)')                  'Given prior information'
         write(6,'(/26x,a,1x,i7)')               'Sample size =',zero
        else
         write(6,'(/6x,a)')                 'Sample size is NOT found'
        endif

       endif                               !search bracketed function

       write(6,'(/4x,a/)') fmt2

  100 continue                                      !End all criteria

      t0 = DTIME(tarray)
      write(6,'(/10x,a,1x,g12.7,1x,a/)') 'Elapsed time',t0,'seconds'
      close(6)

      STOP
      END
c
c*********************************************************************
c
