c************************CONTENTS OF cover.f***************************
c
c   COVER              !coverage given length or length given coverage
c   OPTCOVLEN                          !optimal HPD coverage and lengh
c   PRMINCOV               !Probability of success of minimum coverage
c
c**********************************************************************
c
c For prior Beta parameters a>=1 and b>=1: 
c - Methods 1 (ACC), 2 (WOC-AC), 3 (ALC) and 4 (WOC-AL defunct)
c   . What is minimum coverage, given average sample size n?
c   . At what parameters a1=a+x, b1=(n-x)+b does minimum
c     coverage occur? (This will occur at a1 almost eq b1.)
c   . At average coverage sample size n, what is required
c     length to obtain user specified coverage? (compute 
c     non HPD and HPD lengths)
c   . Probability success (WOC only): 
c       Pr{X=x|a,b} = binom(n x) B(a+x,n-x+b)/B(a,b),
c       x=location where minimum coverage occurs (a1=b1)
c
c   . What is maximum length?
c   . At what parameters a1=a+x, b1=(n-x)+b does maximum
c     length occur? (This will occur at a1 \neq b1.)
c   . At average length sample size n, what is required
c     coverage to obtain user specified length?
c - Inspiration to write this procedure comes from
c   simulation studies to confirm conjecture that
c   coverage and length over any sample size > 0 are
c   unimodal and that the maximum or minimum is located 
c   at a1=b1. If a1<>b1 then a1 differs from b1 by a value
c   of one. We arbitrarily pick the maximum (minimum)
c   result at a1 = b1-1.
c
c**********************************************************************
c
      SUBROUTINE COVER(long,met,CS,w,a,b,n)

c     ..Parameters..
      integer          izero,itwo
      double precision zero,half,one
      parameter       (izero=0,zero=0.0d0,half=0.50d0,one=1.0d0,itwo=2)

c     ..Arguments..
      integer          met,n
      double precision CS,w,a,b
      logical          long

c     ..Local..
      integer          nx,omegn
      double precision dn,dnx,cnt1,cnt2,xval,xval1,fxval,fxval1,
     *                 wa,wb,omeg
      character*10     lab1,lab2,lab3,lab4,sym,asym

c     ..Calling procedures..
c     OPTCOVLEN                          !min coverage or max length
c     COVLEN                       !HPD coverage, HPD/non HPD length
c     HEADCOV                                         !Print headers

c     ..INITIALIZE

      sym = 'symmetric'                                     !labels
      asym = 'asymmetric'
      if (met.le.itwo) then
       lab1 = 'minimum'
       lab2 = 'coverage'
       lab3 = 'length'
       lab4 = 'maximum'
       cnt1 = w
       cnt2 = CS
      else
       lab1 = 'maximum'
       lab2 = 'length'
       lab3 = 'coverage'
       lab4 = 'minimum'
       cnt1 = CS
       cnt2 = w
      endif

      dn    = dble(n)                                   !sample size
      nx    = int(half*(dn+b-a))                !optimum sample size
      omegn = nx                             !Pr success WAC,WAL,WOL
      dnx   = dble(nx)

c     ..if nx>n optimum size is located at n
c     ..if nx<0    ''     ''       ''      0
c     ..if nx<n    ''     ''       ''      int(nx)

      if (nx.gt.n) then                                !ACC,ALC,WOC
       omegn = n
       call OPTCOVLEN(met,    n,    n,dn,  dn,a,b,wa,wb,w,CS,omeg,
     *                                                 xval,fxval)
      elseif (nx.le.izero) then
       omegn = izero
       call OPTCOVLEN(met,izero,izero,dn,zero,a,b,wa,wb,w,CS,omeg,
     *                                                 xval,fxval)
      else
       call OPTCOVLEN(met, nx-1, nx+1,dn, dnx,a,b,wa,wb,w,CS,omeg,
     *                                             xval,fxval)
      endif
      call HEADCOV(1,long,met,omegn,omeg,n,a,b,wa,wb,
     *             sym,asym,lab1,lab2,lab3,lab4,cnt1,cnt2,
     *             xval,xval1,fxval,fxval1)

      if (met.le.itwo) then                                 !ACC,WOC

c     ..non HPD length fxval at point xval
c     ..HPD length fxval1 at point xval1 given initial length fxval

       call COVLEN(2,wa,wb,w,CS,xval,fxval,xval1,fxval1)

       call HEADCOV(2,long,met,omegn,omeg,n,a,b,wa,wb,
     *             sym,asym,lab1,lab2,lab3,lab4,cnt1,cnt2,
     *             xval,xval1,fxval,fxval1)
       call HEADCOV(3,long,met,omegn,omeg,n,a,b,wa,wb,
     *             sym,asym,lab1,lab2,lab3,lab4,cnt1,cnt2,
     *             xval,xval1,fxval,fxval1)

      else                                                      !ALC

c      ..HPD coverage fxval at point xval given wa,wb,w

       call COVLEN(1,wa,wb,w,CS,xval,fxval,xval1,fxval1)

       call HEADCOV(4,long,met,omegn,omeg,n,a,b,wa,wb,
     *             sym,asym,lab1,lab2,lab3,lab4,cnt1,cnt2,
     *             xval,xval1,fxval,fxval1)

      endif                                         !end ACC,WOC,ALC

c     ..Prior Probability of omegn successes in n trials

      call HEADCOV(5,long,met,omegn,omeg,n,a,b,wa,wb,
     *             sym,asym,lab1,lab2,lab3,lab4,cnt1,cnt2,
     *             xval,xval1,fxval,fxval1)

      RETURN
      END
c
c**********************************************************************
c
c Minimum HPD coverage in ACC (met=1,2)
c Maximum HPD/non HPD  length   in ALC   (met=3)
c  non HPD length, HPD length, HPD coverage with COVLEN
c worst outcome sample sizes m1 < m2, nx in n trials
c beta parameters a,b , wa, wb; length w, coverage CS
c optimum function optf at point optx, 
c probability of worst outcome omeg (Beta Binomial)
c
c**********************************************************************
c
      SUBROUTINE OPTCOVLEN(met,m1,m2,n,nx,a,b,wa,wb,w,CS,omeg,
     *                                              optx,optf)

c     ..Parameters..
      double precision  TOL,zero,one
      parameter        (TOL=1.0d-13,zero=0.0d0,one=1.0d0)

c     ..Arguments..
      integer           met,m1,m2
      double precision  n,nx,a,b,wa,wb,w,CS,optx,optf,omeg

c     ..Local..
      integer           j,dj
      double precision  bn,a1,b1,x,xf,x1,xf1
      logical           switch

c     ..Calling procedures..
c     COVLEN                       !HPD coverage, HPD/non HPD length     
      double precision PRMINCOV              !Pr success WAC,WAL,WOL

c     ..INITIALIZE 

      if (met.le.2) then                                    !ACC,WOC
       optf = one
      else                                                      !ALC
       optf = zero
      endif
      optx = zero
      wa   = a
      wb   = b
      bn   = b + n

c     ..ITERATE

      do 100 j = m1,m2,1

       dj = dble(j)
       a1 = a  + dj
       b1 = bn - dj
       switch = .false.

       if (met.le.2) then                                      !ACC,WOC

c      ..HPD coverage xf at x given a1,b1,w
        call COVLEN(1,a1,b1,w,CS,x,xf,x1,xf1)

        if (xf.lt.(optf-TOL)) switch=.true.

       else                                                        !ALC

c      ..non HPD length xf1 at point x1
c      ..HPD length xf at point x given initial length xf1
        call COVLEN(2,a1,b1,w,CS,x1,xf1,x,xf)

        if (xf.gt.(optf+TOL)) switch=.true.
       endif

       if (switch) then
        optx = x
        optf = xf
        wa   = a1
        wb   = b1
       endif

  100 continue

      omeg = PRMINCOV(n,nx,a,b)         !Prob{X=x | a,b} (Beta Binomial)

      RETURN
      END
c
c**********************************************************************
c
c Probability success 
c     ..Pr{X=x|n,a,b} = binom(n x) B(a+x,n-x+b)/B(a,b)
c     ..a,b are beta parameters
c
c**********************************************************************
c
      FUNCTION PRMINCOV(n,x,a,b)

c     ..Parameters..
      double precision one
      parameter       (one=1.0d0)

c     ..Arguments
      double precision PRMINCOV,n,x,a,b

c     ..Calling procedures..
      double precision GAMMLN

      PRMINCOV  = GAMMLN(n + one) + GAMMLN(n - x + b) 
     2            + GAMMLN(a + b) + GAMMLN(a + x)
     3            - ( GAMMLN(n - x + one) + GAMMLN(x + one)
     4            + GAMMLN(a + b + n) + GAMMLN(a) + GAMMLN(b) )

      RETURN
      END
c
c**********************************************************************
c
