c***********************************************************************
c
      PROGRAM MPCP        !Multiple Path Change Point
c
c***********************************************************************
c     version NORMAL
c
c     Multiple Path Change Point Study
c     by Data Augmentation Procedure
c
c PROGRAM PLAN 
c A. Read data ; 
c B. Read parameters 
c C. MPCP update project
c     PRIORS selection of MULTINOMIAL, NORMAL variates
c     Repeat
c      Sample column position from posterior distribution
c      Update Dirichlet, Gamma and Normal parameter updates
c      Generate Multinomial, Gamma and Normal variates
c     until STOP
c
c**************************CONTENTS*************************************
c
c     PROGRAM MPCP   - Initialize for DATAUGM
c     DATAUGM        - main subroutine
c
c***********************************************************************
c
c NOTA :
c    Maximum number of data rows rmax and columns cmax
c
c    Necessary files in cwd : 'mpc.par' - parameter file
c                             'mpc.dat' - data file
c
c***********************************************************************
c
c     PARAMETER DEFINITION
c
c     rmax,cmax : parameters to state maximum number
c                 of rows m, columns n; m<=rmax and n<=cmax
c     tmax      : at least max(m,n) used by itmpn (index
c               : vector) of row and column indices
c     X(m,n)    : data matrix of m rows and n columns
c     R(m,2)    : Precision variates generated from Gamma parameters
c     nmu(m,2)  : mu'|R,X ~ N(u*,sigma^2*)
c     tau(m)    : change point at column j=1,n for row i=1,m
c     pn(n)     : multinomial variates generated from Dirichlet dist.
c     pr(m,n)   : posterior distribution PR{tau=j|X,nmu,R,tau,pn}
c     pd(m)     : marginal of posterior distribution

c     samprow,sampcol : vectors of row and column indices
c     ..Update arrays
c     mu(m,2),updmu(m,2),upsig(m,2) : Normal parms for 2 dist'ns
c     alpha,nalpha(n)       : Dirichlet parameters
c     agam,nagam,bgam,nbgam : Gamma shapes and scales for 2 dist'ns

c     ..Summary vectors
c     gm1,gm2 : E(X),X~Gamma(a,b) (2 gamma variates averaged
c		over number of iterations)
c     snalp(n)  : E(X),X~dir averaged over number of iterations
c     rsmnmu(m),rctnmu(rmax) : Sum and counter of differences
c                              between 2 updated means
c     ..Work vectors
c     cord(m,n) : matrix to identify missing values
c     nvar(m)   : sample size of row i=1,m
c     tmpm(m),tmpn1(n),tmpn2(n),tmpn3(n),itmpn(max(m,n))
c
c***********************************************************************
c
c     ..Parameters..
      integer           rmax,cmax,tmax,           !size limit parameters
     *                  limrow              !number of rows/cols to scan
      character*9       parmf,datf                 !parameter file names
      parameter        (rmax=500,cmax=500,tmax=500,limrow=10,
     *                  parmf='mpc.par',datf='mpc.dat')

c     ..Scalar arguments..
      integer          m,n                            !m rows, n columns

c     ..Array arguments..
      integer          tau(rmax),
     *                 samprow(limrow),sampcol(limrow),      !max output
     *                 ind(limrow)
      double precision X(rmax,cmax),
     *                 pr(rmax,cmax),pd(rmax),pn(cmax),              
     *                 alpha(cmax),nalpha(cmax),              !Dirichlet
     *                 agam(rmax,2),nagam(rmax,2),            !a1,a2 Gam
     *                 bgam(rmax,2),nbgam(rmax,2),            !b1,b2 Gam
     *                 omega(2),                              !om1,om2 N
     *                 mu(rmax,2),nmu(rmax,2),                !mu1,mu2 N
     *                 R(rmax,2),                             !R1,R2   G
     *                 updmu(rmax,2),updsig(rmax,2),          !updates N
     *                 meantx(rmax,2),                        !row  mean
     *                 gm1(rmax),gm2(rmax),                 !E(Ri),i=1,2
     *                 snalp(cmax)               !mean(alpha)/sum(alpha)

c     ..Work vectors..
      integer          cord(rmax,cmax),nvar(rmax),itmpn(tmax),
     *                 rctnmu(rmax)
      double precision tmpm(rmax),tmpn1(cmax),tmpn2(cmax),
     *                 tmpn3(cmax),rsmnmu(rmax)
      character*9      fname

c     ..Calling procedures..
c     READROWCOL             !Number of rows and columns in data matrix
c     DATAUGM                                          !Main subroutine
c
c
c***********************************************************************
c
c     Check for presence of required parameter and data files
c
c***********************************************************************
c
      write(6,'(/2x,3a)')              'Data file to read is "',datf,'"'
      write(6,'(2x,3a)')         'Parameter file to read is "',parmf,'"'
c
c***********************************************************************
c
c    Read number of rows and columns contained in data matrix.
c    Before proceeding check that m rows, n columns do
c    not exceed limits imposed by program.
c
c***********************************************************************
c
      fname = 'Parameter'
      call READROWCOL(parmf,fname,m,n,rmax,cmax,
     1                tmax,limrow)

      call DATAUGM(datf,parmf,m,n,tmax,limrow,X,cord,
     1             tau,nvar,pr,pd,pn,alpha,nalpha,
     2             omega,agam,nagam,bgam,nbgam,gm1,gm2,
     3             snalp,mu,nmu,R,updmu,updsig,meantx,
     4             samprow,sampcol,ind,
     5             tmpm,tmpn1,tmpn2,tmpn3,itmpn,
     6             rsmnmu,rctnmu)

      STOP
      END
c
c***************************MAIN SUBROUTINE*****************************
c
      SUBROUTINE DATAUGM(datfil,parfil,m,n,mnlen,limrow,X,cord,
     1                   tau,nvar,pr,pd,pn,alpha,nalpha,
     2                   omega,agam,nagam,bgam,nbgam,gm1,gm2,
     3                   snalp,mu,nmu,R,updmu,updsig,
     4                   meantx,samprow,sampcol,ind,
     5                   tmpm,tmpn1,tmpn2,tmpn3,itmpn,
     6                   rsmnmu,rctnmu)

c     ..Parameters..
      character*9      dumpdaf,dumppaf,dumpmis             !dump files
      parameter       (dumpdaf='dump.dat',dumppaf='dump.par',
     *                 dumpmis='dump.mis')

c     ..Arguments..
      integer          m,n,mnlen,limrow,
     *                 cord(m,n),tau(m),
     *                 nvar(m),itmpn(mnlen),rctnmu(m),
     *                 samprow(limrow),sampcol(limrow),
     *                 ind(limrow)
      double precision X(m,n),
     *                 pr(m,n),pd(m),pn(n),
     *                 alpha(n),nalpha(n),omega(2),               
     *                 agam(m,2),nagam(m,2), 
     *                 bgam(m,2),nbgam(m,2),
     *                 gm1(m),gm2(m),snalp(n),rsmnmu(m),
     *                 mu(m,2),nmu(m,2),R(m,2),
     *                 updmu(m,2),updsig(m,2),meantx(m,2),
     *                 tmpm(m),tmpn1(n),tmpn2(n),tmpn3(n)
      character*9      datfil,parfil     !input data and parameter files

c     ..Local..
      integer          iseed,mult,multf,S,liter,jd,maxsize,
     *                 filecnt,countf,                  !file size check
     *                 nrow,ncol              !# of rows and cols in use
      double precision misval,varval,minel,maxel            !parm checks
      real             t0,tarray(2)                      !time execution
      logical          MISS,VAR,opendirf,opengamf           !parm checks
      character*9      fname                             !file type name
      character*10     distyp,mess1,mess2
      character*15     mpcalpn,mpcgam1,mpcgam2,mpcavgd,
     *                 mpcnor1,mpcnor2,mpcgexp,mpcndif,mpcpnch

c     ..Calling procedures..
c                      READAT,                         !Read data matrix
c                      READPAR,                     !Read parameter file
c                      DUMPAR,                     !Check parameter info 
c                      INVECT,                !Initialize update vectors
c                      IDENT,                     !Locate missing values
c                      ITPROJ,                 !Gibbs sampling algorithm
c                      FILMESS,                                  !header
      real             DTIME                              !Program timer
c
c***********************************************************************
c
c A   ..Read data matrix
c
c***********************************************************************
c
      fname = 'Data'
      call READAT(datfil,dumpdaf,fname,m,n,X,minel,maxel)

      write(6,'(/4x,3a)')                 'Wrote to file: "',dumpdaf,'"'
      write(6,'(6x,3a)')'NOTE: You are advised to inspect "',dumpdaf,'"'
c
c***********************************************************************
c
c B  ..Input initial parameter values..
c     read parameter file parfil
c
c***********************************************************************
c
c B.1) Read parameter file

      fname = 'Parameter'
      call READPAR(parfil,fname,m,n,mnlen,iseed,S,liter,mult,
     1             multf,MISS,maxsize,misval,VAR,varval,jd,
     2             limrow,agam,bgam,mu,omega,alpha,
     3             samprow,sampcol,itmpn,
     4             mpcalpn,mpcgam1,mpcgam2,mpcnor1,mpcnor2,
     5             mpcavgd,mpcgexp,mpcndif,mpcpnch)

c     ..Check and dump parameters to files..
      call DUMPAR(dumppaf,fname,m,n,X,iseed,S,liter,mult,multf,
     1            MISS,misval,VAR,varval,minel,maxel,jd,
     2            limrow,nrow,ncol,agam,bgam,mu,omega,alpha,
     3            samprow,sampcol,nvar,
     4            filecnt,countf,maxsize,opendirf,opengamf,
     5            mpcavgd,mpcgexp,mpcpnch)

      write(6,'(/4x,3a)')                 'Wrote to file: "',dumppaf,'"'
      write(6,'(6x,3a)')'NOTE: You are advised to inspect "',dumppaf,'"'

c     ..Initialize parameter 'updates'..
      distyp='Gamma'
      call INVECT(m,2,agam,nagam)
      call INVECT(m,2,bgam,nbgam)
      write(6,'(/4x,3a)')               'Initialized ',distyp,' updates'

      distyp='Dirichlet'
      call INVECT(n,1,alpha,nalpha)
      write(6,'(4x,3a)')                'Initialized ',distyp,' updates'

      distyp='Normal'
      call INVECT(m,2,mu,nmu)
      write(6,'(4x,3a)')                'Initialized ',distyp,' updates'
c
c***********************************************************************
c
c B.2) ..Find missing value coordinates..

      fname = 'Missing'
      if (MISS) then 
       call IDENT(dumpmis,fname,m,n,nvar,misval,X,cord)
       write(6,'(/4x,3a)')                'Wrote to file: "',dumpmis,'"'
       write(6,'(6x,3a)')
     *                  'NOTE: You are advised to inspect "',dumpmis,'"'
      endif
c
c***********************************************************************
c
c    ..Open output files ..
c    ..NOTE: UNIT 13 is opened (and closed) in procedure ITPROJ
c    ..      for the following jobs:
c    ..      average Dirichlet updates (mpcavgd) 
c    ..      average Gamma parameter updates (mpcgexp)
c    ..      average difference N parm (mean) updates (mpcndif)

c     ..Gamma updates, Normal updates (distributions 1,2) 
      if (opengamf) then
       open(8, file=mpcgam1) 
       distyp='Gamma'
       mess1='shape'
       mess2='scale'       
       call FILMESS(8,nrow,samprow,mpcgam1,parfil,distyp,1,mess1,mess2)
       open(9, file=mpcgam2) 
       call FILMESS(9,nrow,samprow,mpcgam2,parfil,distyp,2,mess1,mess2)
       open(11,file=mpcnor1) 
       distyp='Normal'
       mess1='mean'
       mess2='variance'
       call FILMESS(11,nrow,samprow,mpcnor1,parfil,distyp,1,mess1,mess2)
       open(12,file=mpcnor2) 
       call FILMESS(12,nrow,samprow,mpcnor2,parfil,distyp,2,mess1,mess2)
      endif

c     ..Dirichlet updates (unit 10), prob of no change (unit 14)..
      if (opendirf) then
       open(10,file=mpcalpn) 
       distyp='Dirichlet'
       call FILMESS(10,ncol,sampcol,mpcalpn,parfil,distyp)
       open(14,file=mpcpnch) 
       distyp='no change'
       call FILMESS(14,ncol,sampcol,mpcpnch,parfil,distyp)
      endif

      t0 = DTIME(tarray)

      write(6,'(/2x,a/)')                    'Begin iteration procedure'
      call ITPROJ(iseed,mult,multf,m,n,jd,nrow,
     1            ncol,S,filecnt,countf,
     2            cord,nvar,X,tau,pr,pd,pn,
     3            omega,agam,nagam,bgam,nbgam,
     4            mu,nmu,R,alpha,nalpha,
     5            updmu,updsig,meantx,gm1,gm2,snalp,
     6            samprow,sampcol,ind,
     7            tmpm,tmpn1,tmpn2,tmpn3,itmpn,
     8            rsmnmu,rctnmu,MISS,opendirf,opengamf,
     9            mpcavgd,mpcgexp,mpcndif,mpcpnch)
      write(6,'(/2x,a/)')                     'End  iteration procedure'

      t0 = DTIME(tarray)
      write(6,'(/4x,a,f13.5/)')                  'time execution : ',t0

      if (opengamf) then
       close(8)
       close(9)
       close(11)
       close(12)
      endif

      if (opendirf) then
       close(10)
       close(14)
      endif
      
      RETURN
      END
c
c***********************************************************************
c
