c****************************CONTENTS********************************
c
c     FILLIN         - Fill in missing value cells of data matrix
c     INDEXX         - Index ascending order array 
c                      (Numerical Recipes 1990)
c     INDEXI         - Index ascending order integer array 
c                      (Numerical Recipes (modified) 1990)
c     SHIFTP         - Shift elements to correct under/over flow
c     AVGDIF         - Sum differences of 2 updated Normal means
c
c
c********************************************************************
c
c     Fill missing values with Normal variates. 
c     If iter=0 then fill in with prior means mu
c
c********************************************************************
c
      SUBROUTINE FILLIN(iter,m,n,nvar,idum,tau,mu,sig,cord,X)

c     ..Arguments..
      integer          iter,m,n,idum,nvar(m),tau(m),cord(m,n)
      double precision mu(m,2),sig(m,2),X(m,n)

c     ..Local..
      integer          i,j

c     ..Calling function..
c      NORMDEV                      !generate normal variate

      i = 0
   10 i = i+1
      j = 0
   20 j = j+1
      if (cord(i,j).eq.1) then                   !if missing
       if (j.le.tau(i)) then
        if (iter.eq.0) then
         X(i,j) = mu(i,1)
        else
         call NORMDEV(idum,1,1,mu(i,1),sig(i,1),X(i,j))
        endif
       else
        if (iter.eq.0) then
         X(i,j) = mu(i,2)
        else
         call NORMDEV(idum,1,1,mu(i,2),sig(i,2),X(i,j))
        endif
       endif
      endif
      if (j.lt.nvar(i)) GOTO 20
      if (i.lt.m) GOTO 10

      RETURN
      END
c
c********************************************************************
c
c     Numerical Recipes (1990) indexing of real vector
c     outputs the array indx such that ARRIN(indx(j)) is in 
c     ascending order for j=1,..,n.
c
c********************************************************************
c
      SUBROUTINE INDEXX(n,ARRIN,INDX)

      integer          n,INDX(n)
      double precision ARRIN(n),q

      integer j,ir,l,indxt,i

      do 11 j=1,n
        INDX(j)=j
  11  continue
      l=n/2+1
      ir=n
  10  continue

      if(l.gt.1)then
       l=l-1
       indxt=INDX(l)
       q=ARRIN(indxt)
      else
       indxt=INDX(ir)
       q=ARRIN(indxt)
       INDX(ir)=INDX(1)
       ir=ir-1
       if(ir.eq.1)then
        INDX(1)=indxt
        RETURN
       endif
      endif
      i=l
      j=l+l

  20  if(j.le.ir)then
       if(j.lt.ir)then
        if(ARRIN(INDX(j)).lt.ARRIN(INDX(j+1)))j=j+1
       endif
       if(q.lt.ARRIN(INDX(j)))then
        INDX(i)=INDX(j)
        i=j
        j=j+j
       else
        j=ir+1
       endif
       GOTO 20
      endif
      INDX(i)=indxt
      GOTO 10

      END
c
c********************************************************************
c
c     Numerical Recipes (1990) indexing of integer vector
c     outputs the array INDX such that ARRIN(INDX(j)) is in 
c     ascending order for j=1,..,n.
c
c********************************************************************
c
      SUBROUTINE INDEXI(n,ARRIN,INDX)

      integer          n,ARRIN(n),INDX(n)
      double precision q

      integer j,ir,l,indxt,i

      do 11 j=1,n
       INDX(j)=j
  11  continue
      l=n/2+1
      ir=n
  10  continue

      if(l.gt.1)then
       l=l-1
       indxt=INDX(l)
       q=ARRIN(indxt)
      else
       indxt=INDX(ir)
       q=ARRIN(indxt)
       INDX(ir)=INDX(1)
       ir=ir-1
       if(ir.eq.1)then
        INDX(1)=indxt
        RETURN
       endif
      endif
      i=l
      j=l+l

  20  if(j.le.ir)then
       if(j.lt.ir)then
        if(ARRIN(INDX(j)).lt.ARRIN(INDX(j+1)))j=j+1
       endif
       if(q.lt.ARRIN(INDX(j)))then
        INDX(i)=INDX(j)
        i=j
        j=j+j
       else
        j=ir+1
       endif
       GOTO 20
      endif
      INDX(i)=indxt
      GOTO 10

      END
c
c********************************************************************
c
c     Shift elements of Y(n) should abs(max(Y)) > LIM
c     count indicates at what iteration under/overflow occurs,
c     row is data matrix row,
c     jd is column position for Dirichlet parameters
c
c********************************************************************
c
      SUBROUTINE SHIFTP(LIM,row,count,n,jd,Y,indx)

c     ..Arguments..
      integer          row,count,n,jd,n1,indx(n)
      double precision LIM,Y(n)

c     ..Local..
      integer          i
      double precision shift
      logical          OUT

c     ..calling procedure..
c     INDEXX                               !index of sorted values

      OUT=.false.
      n1 = n-jd                              !modified sample size

      if (n1.lt.n) then
       do 30 i = jd+1,n
        Y(i-jd) = Y(i)
   30  continue
       do 40 i = n1+1,n
        Y(i) = 0.0d0
   40  continue
      endif

      if (n1.gt.1) then
       call INDEXX(n1,Y,indx)
      else
       indx(1) = 1
      endif

      if (Y(indx(n1)).gt.LIM) then     !don't want infinite values
       OUT=.true.
       shift = Y(indx(n1)) - (LIM-2.0d0)
       do 50 i = 1,n1
        Y(i) = Y(i) - shift
   50  continue
       GOTO 70
      endif

      if (Y(indx(n1)).lt.(-LIM)) then !one non-zero value suffices
       OUT=.true.
       shift = Y(indx(n1)) + (LIM-2.0d0)
       do 60 i = 1,n1
        Y(i) = Y(i) - shift
   60  continue
      endif

   70 if (OUT) 
     *  write(6,'(2(a,i5))')  'under/overflow at iteration',count,
     *                                                 ' row',row

      if(n1.lt.n) then
       do 80 i = n,jd+1,-1
        Y(i) = Y(i-jd)
   80  continue
       do 90 i = 1,jd
        Y(i) = 0.0d0
   90  continue
      endif

      RETURN
      END
c
c********************************************************************
c
c     Sum differences of two Normals, given column position (tau) 
c     If tau=nvar, there are no differences in means to compute, 
c     because no change has occurred; Use counter only
c     when tau < nvar. mu is updated mean1 and mean2 for each row;
c     mus and muc are weighted sums and counts;
c     rmus,rmuc are vector row sums and counts;
c
c********************************************************************
c
      SUBROUTINE AVGDIF(n,nvar,tau,mu, mus,muc,rmus,rmuc)

c     ..Parameters..
      integer          one
      parameter       (one=1)

c     ..Arguments..
      integer          n,nvar(n),tau(n),muc,rmuc(n)
      double precision mus,rmus(n),mu(n,2)

c     ..Local..
      integer          i
      double precision avg1,avg2

      do 100 i = 1,n                                        !n rows
       if (tau(i).lt.nvar(i)) then
        avg1    = mu(i,1)
        avg2    = mu(i,2) - avg1 
        mus     = mus + avg2                          !weighted sum
        muc     = muc + one                         !weighted count
        rmus(i) = rmus(i) + avg2                           !row rum
        rmuc(i) = rmuc(i) + one                          !row count
       endif
  100 continue

      RETURN
      END
c
c********************************************************************
c
