c******************************CONTENTS*******************************
c
c      random number generators
c      -   RAN1  Uniform deviate (Press et al. 1992)
c      -   GAMDEV       - Gamma deviate of parameters a,b 
c                         (Bratley et al. 1987)
c           RGS         - a < 1
c           RGKM3       - a >=1
c          RMULTNM
c           Random sample selection of size k from a set of 
c           distinct objects A= {1,2,...,n}, each A(j) 
c           associated to a vector of weights W=(w1,w2,...,wn) 
c      -   RDIRI Multinomial vector of deviates 

c      -   GENBET  Beta deviate (Cheng, 1978)
c      -   POIDEV  Poisson deviate (Press et. al. 1990)
c
c**********************************************************************
c
c Press, Teukolsky, Vetterling and Flannery: Numerical Recipes 
c  in Fortran, 2nd Edition (1992) 
c
c**********************************************************************
c
      FUNCTION RAN1(idum)

      INTEGER idum,IA,IM,IQ,IR,NTAB,NDIV
      double precision RAN1,AM,EPS,RNMX
      PARAMETER (IA=16807,IM=2147483647,AM=1.0d0/IM,IQ=127773,IR=2836,
     *           NTAB=32,NDIV=1+(IM-1)/NTAB,EPS=1.2d-7,RNMX=1.0d0-EPS)
      INTEGER j,k,iv(NTAB),iy
      SAVE iv,iy
      DATA iv /NTAB*0/, iy /0/

      if (idum.le.0.or.iy.eq.0) then
       idum=max(-idum,1)
       do 11 j=NTAB+8,1,-1
        k=idum/IQ
        idum=IA*(idum-k*IQ)-IR*k
        if (idum.lt.0) idum=idum+IM
        if (j.le.NTAB) iv(j)=idum
   11  continue
       iy=iv(1)
      endif
      k=idum/IQ
      idum=IA*(idum-k*IQ)-IR*k
      if (idum.lt.0) idum=idum+IM
      j=1+iy/NDIV
      iy=iv(j)
      iv(j)=idum
      RAN1=min(AM*iy,RNMX)

      RETURN
      END
c
c*********************************************************************
c
c     Generate X from gamma(na,nb),na=shape,nb=scale
c     E(X)=na*nb and Var(X)= na*nb^2
c     pp.324,325 in Bratley, Fox and Schrage 
c     (1987, Springer-Verlag)
c     na > 1 RGKM3
c     0 < na <= 1 RGS
c
c*********************************************************************
c
      SUBROUTINE GAMDEV(iseed,m,EPS,na,nb,X)
   
c     ..Parameters..
      double precision zero,one
      parameter        (zero=0.0d0,one=1.0d0)

c     ..Arguments..
      integer          iseed,m
      double precision EPS,na(m,2),nb(m,2),X(m,2)

c     ..Local..
      integer          k,i,j
      double precision work(6)
 
c     ..calling functions..
      double precision     RGS
      double precision     RGKM3

      work(1)=-1
      do 50 i=1,m
       do 40 j = 1,2
        if ((na(i,j).gt.zero).and.(nb(i,j).gt.zero)) then
   10    if (na(i,j).le.one) then
          X(i,j) = RGS(na(i,j),iseed)
         else
          X(i,j) = RGKM3(na(i,j),work,k,iseed)
         endif
         if (X(i,j).le.EPS) GOTO 10
        else
         write(6,'(//6x,2a)')              'Illegal negative element',
     *                                            ' in data matrix'
         STOP 'in GAMDEV (ITPROJ)'
        endif
        X(i,j) = X(i,j)*nb(i,j)
   40  continue
   50 continue

      RETURN
      END
c
c********************************************************************
c
c     Gamma variate with parameter  0 < alpha <= 1
c      alp  = Gamma distribution parameter
c      idum = random number seed
c      RAN1 = uniform random number generator
c
c     References: Ahrens,J.H. and U. Dieter (1972), Computer
c      methods for sampling from Gamma, Beta, Poisson and 
c      Binomial distributions, computing, vol. 12, pp. 223-246.
c      Tadikamalla, P.R. and M.E. Johnson (1981), A complete
c      guide to Gamma variate generation, amer. j. of math. and
c      man. sci., vol. 1, pp. 213-236.
c
c********************************************************************
c
      FUNCTION RGS(alp,idum)

c     ..Arguments..
      integer           idum
      double precision  RGS,alp

c     ..Local..
      double precision  U1,B,P,U2,X

c     ..Calling procedure..
      double precision  RAN1

  100 U1 = RAN1(idum)
      B = (2.718281828d0 + alp)/2.718281828d0
      P = B*U1
      U2 = RAN1(idum)
      if (P.gt.1.0d0) GOTO 300
      X = exp(log(P)/alp)
      if (U2.gt.exp(-X)) GOTO 100
      RGS = X
      RETURN
  300 X = -log((B-P)/alp)
      if (log(U2).gt.(alp-1.0d0)*log(X)) GOTO 100
      RGS = X

      RETURN
      END
c
c********************************************************************
c
c     Gamma variate with parameter alpha > 1
c     inputs:
c      alp    = distribution parameter
c      work() = vector of work cells; on first call work(1)=-1.
c       work() must be preserved by caller between calls.
c      k = work cell. K must be preserved by caller between calls.
c      idum = random number seed
c      RAN1 = uniform random number generator
c
c     References: Cheng,R.C. and G.M. Feast (1979), Some
c      simple Gamma variate generators, applied stat. vol 28,
c      pp. 290-295. Tadikamalla, P.R. and M.E. Johnson (1981),
c      A complete guide to Gamma variate generation, amer. j.
c      of math. and man. sci., vol. 1, pp. 213-236.
c
c*******************************************************************
c
      FUNCTION RGKM3(alp,work,k,idum)

c     ..Parameters..
      double precision zero,one
      parameter        (zero=0.0d0,one=1.0d0)

c     ..Arguments..
      integer          idum,k
      double precision RGKM3,alp,work(6)

c     ..Local..
      double precision U1,U2,U,w

c     ..calling procedure..
      double precision RAN1

      if(work(1).eq.alp) GOTO 100
      work(1) = alp
      k = 1
      if (alp.gt.2.5) k = 2
      work(2) = alp - one
      work(3) = (alp - one/(6.0d0*alp))/work(2)
      work(4) = 2.0d0/work(2)
      work(5) = work(4) + 2.0d0
      GOTO (1, 11), k

    1 U1 = RAN1(idum)
      U2 = RAN1(idum)
      GOTO 20
   11 work(6) = sqrt(alp)
   15 U1 = RAN1(idum)
      U  = RAN1(idum)
      U2 = U1 + (one-1.86d0*U)/work(6)
      if ((U2.le.zero).or.(u2.ge.one)) GOTO 15
   20 w = work(3)*U1/U2
      if((work(4)*U2 - work(5) + w + one/w).le.zero) GOTO 200
      if((work(4)*log(U2) - log(w) + w - 1.0d0).lt.zero) GOTO 200
  100 GOTO (1, 15), k
  200 RGKM3 = work(2)*w

      RETURN
      END
c
c*********************************************************************
c
c     Generate a random sample of size k from a set of
c     distinct objects A={jd+1,jd+2,...,n}, each A(j) associated to 
c     weight vector p=(wjd+1,...,wn).
c   INPUT
c     idum : initial seed; sample size k; n distinct objects;
c     p(n) is vector of weights; 
c     cump(n) and X(k) are dummy arrays;
c   OUTPUT
c     random sample tau(k) of selected items
c
c*********************************************************************
c
      SUBROUTINE RMULTNM(idum,k,n,jd,p,cump,X,tau)

c     ..Scalar arguments..
      integer          idum,k,n,jd

c     ..Array arguments..
      integer          tau(k)
      double precision p(n),cump(n),X(k)

c     ..Local scalars..
      integer          i,j

c     ..Calling function..
      double precision RAN1

c    ..vector of cumulative sums..

      cump(jd+1) = p(jd+1)
      do 10 j = jd+2,n
       cump(j) = cump(j-1)+p(j)
   10 continue

c     ..Generate uniform variates..

      do 20 i = 1,k
       tau(i) = i                               !just initializing
       X(i) = RAN1(idum)
   20 continue

c    ..generate sample of size k..
c    ..NOTE: We will not use Press et al. (1990) routine LOCATE
c    ..because LOCATE assumes that cump is monotonic. In many
c    ..cases it is not.
      do 40 i = 1,k
       if(X(i).le.cump(jd+1)) then
        tau(i) = jd+1
        GOTO 40
       endif
       do 30 j = jd+2,n
        if (cump(j-1).lt.X(i).and.X(i).le.cump(j)) then
         tau(i) = j
         GOTO 40
        endif
   30  continue
   40 continue

      RETURN
      END
c
c*********************************************************************
c
c generate multinomial variate from dirichlet parameters
c     .. tmp1: used for cumulative sum and oneminusy
c     .. tmp2: used for shape2 and oneminusycumprod
c     .. jd  : indicates where index begins for dirichlet
c               parameter > 0
c
c*********************************************************************
c
      SUBROUTINE RDIRI(idum,n,jd,shape1,tmp1,tmp2,y,pnout)

c     ..Parameters..
      double precision zero,one
      parameter        (zero=0.0d0,one=1.0d0)

c     ..Scalar arguments..
      integer          idum,n,jd

c     ..array arguments..
      double precision shape1(n),tmp1(n),tmp2(n),y(n),
     *                 pnout(n)

c     ..local variables..
      integer j
      double precision sum

c     ..calling function..
      double precision GENBET

c     ..create shape 2 for beta generation
c
c     a. take sum and cumulative sum of shape1

      sum        = shape1(jd+1)
      tmp1(jd+1) = sum
      do 10 j = jd+2,n
       sum     = sum + shape1(j)
       tmp1(j) = sum
   10 continue

c     b. creation of shape 2 of length (n-1)

      do 20 j = jd+1,n
       tmp2(j) = sum - tmp1(j)
   20 continue

c     .. sample (n-1) times from beta distribution
c     .. subtract resultant vector elements from 1

      do 30 j = jd+1,(n-1)
       y(j) = GENBET(idum,shape1(j),tmp2(j))
       tmp1(j) = one - y(j)
   30 continue

c     .. cumulative product of n-2 elements of oneminusy
c     .. and combine resultant vector with 1 at first element

      tmp2(jd+1) = one
      do 40 j = jd+2,(n-1)
       tmp2(j) = tmp2(j-1)*tmp1(j-1)
   40 continue

c     .. compute dirichlet parameters
      sum = zero
      do 50 j = jd+1,(n-1)
       pnout(j) = y(j)*tmp2(j)
       sum = sum + pnout(j)
   50 continue
      pnout(n) = zero
      if (sum.lt.one) pnout(n) = one - sum

      RETURN
      END
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c
c*********************************************************************
c
c     (Potential problem at label 190 .)
c
c               GeNerate BETa random deviate
c                              Function
c     Returns a single random deviate from the beta distribution with
c     parameters A and B.  The density of the beta is
c               x^(a-1) * (1-x)^(b-1) / B(a,b) for 0 < x < 1
c
c                              Arguments
c
c     A --> First parameter of the beta distribution
c
c     B --> Second parameter of the beta distribution
c
c     IDUM-->parameter to RAN1(IDUM) as a source of uniform random
c            deviates
c
c                              Method
c
c     R. C. H. Cheng
c     Generating Beta Variatew with Nonintegral Shape Parameters
c     Communications of the ACM, 21:317-322  (1978)
c     (Algorithms BB and BC)
c     (modification from roxane db - 92 09 15)
c
c********************************************************************
c
      FUNCTION GENBET(IDUM,aa,bb)

C     .. Parameters ..
      DOUBLE PRECISION GENBET,expmax,infnty,epsi
      PARAMETER (expmax=709.0d0,infnty=1.d307,epsi=1.d-320)

C     .. Scalar Arguments ..
      INTEGER          IDUM
      DOUBLE PRECISION aa,bb
C     ..
C     .. Local Scalars ..
      DOUBLE PRECISION a,alpha,b,beta,delta,gamma,k1,k2,olda,
     *                 oldb,r,s,t,u1,u2,v,w,y,z,dw1
      LOGICAL          qsame

c     ..Calling function..
      double precision RAN1
C     ..
C     .. Save statement ..
      SAVE olda,oldb,alpha,beta,gamma,k1,k2
C     ..
C     .. Data statements ..
      DATA olda,oldb/-1.0d0,-1.0d0/

C     .. Executable Statements ..

      qsame = ((olda.EQ.aa) .AND. (oldb.EQ.bb))
      IF (qsame) GO TO 20
      IF (.NOT. ((aa.LE.0.0d0).OR.(bb.LE.0.0d0))) GO TO 10
      WRITE (*,*) ' AA or BB <= 0 in GENBET - Abort!'
      WRITE (*,*) ' AA: ',aa,' BB ',bb
      STOP 

   10 olda = aa
      oldb = bb
   20 IF (.NOT.(min(aa,bb).GT.1.0d0)) GO TO 100   !BC algorithm
c
C     Alborithm BB : "Squeeze Method"
c
C     Initialize
C
      IF (qsame) GO TO 30
      a = min(aa,bb)
      b = max(aa,bb)
      alpha = a + b
      beta = sqrt((alpha-2.0d0)/ (2.0d0*a*b-alpha))
      gamma = a + 1.0d0/beta
   30 CONTINUE
   40 u1 = RAN1(idum)
      if ((u1.le.epsi).or.((1.0d0-u1).le.epsi)) GO TO 40
C
C     Step 1
C
   41 u2 = RAN1(idum)
      if ((u2.le.epsi).or.((10d0-u2).le.epsi)) GO TO 41
      v = beta*(log(u1)-log(1.0d0-u1))

      IF (.NOT. (v.GT.expmax)) GO TO 50
      w = infnty
      GO TO 60

   50 w = a*exp(v)
   60 t = 2.0d0*log(u1)+log(u2)
      z = exp(t)
      r = gamma*v - 1.3862944d0
      s = a + r - w
C
C     Step 2
C
      IF ((s+2.609438d0).GE.(5.0d0*z)) GO TO 70
C
C     Step 3
C
      IF (s.GT.t) GO TO 70
C
C     Step 4
C
      dw1 = log(alpha)-log(b+w)
      IF ((r+alpha*dw1).LT.t) GO TO 40
C
C     Step 5
C
   70 IF (.NOT.(aa.EQ.a)) GO TO 80
      genbet = w/ (b+w)
      GO TO 90

   80 genbet = b/ (b+w)
   90 GO TO 230
c
C     Algorithm BC : min(a,b) small or max(a,b) large
c
C     Initialize
C
  100 IF (qsame) GO TO 110

      a = max(aa,bb)
      b = min(aa,bb)
      alpha = a + b
      beta = 1.0d0/b
      delta = 1.0d0 + a - b
      k1 = delta* (0.0138889d0+0.0416667d0*b)/ (a*beta-0.777778d0)
      k2 = 0.25d0 + (0.5d0+0.25d0/delta)*b
  110 CONTINUE

  120 u1 = RAN1(idum)
      if ((u1.le.epsi).or.((1.0d0-u1).le.epsi)) GO TO 120
C
C     Step 1
C
  121 u2 = RAN1(idum)
      if ((u2.le.epsi).or.((1.0d0-u2).le.epsi)) GO TO 121

      IF (u1.GE.0.5d0) GO TO 130
C
C     Step 2
C
      y = u1*u2
      z = u1*y
      IF ((0.25d0*u2+z-y).GE.k1) GO TO 120
      GO TO 170
C
C     Step 3
C
  130 z = u1**2*u2

      IF (.NOT. (z.LE.0.25d0)) GO TO 160
      v = beta*(log(u1)-log(1.0d0-u1))
      IF (.NOT. (v.GT.expmax)) GO TO 140
      w = infnty
      GO TO 150

  140 w = a*exp(v)
  150 GO TO 200

  160 IF (z.GE.k2) GO TO 120
C
C     Step 4
C     Step 5
C
  170 v = beta*(log(u1)-log(1.0d0-u1))
      IF (.NOT. (v.GT.expmax)) GO TO 180
      w = infnty
      GO TO 190

  180 w = a*exp(v)
c
c     HERE lies a POTENTIAL PROBLEM: perhaps resolved with
c     new statement. Instead of log(a/(b+w)), write
c     log(a) - log(b+w)
c
  190 dw1 = log(alpha)-log(b+w)
      IF ((alpha*(dw1+v)-1.3862944d0).LT.log(z)) then
       GO TO 120
      endif
C
C     Step 6
C
  200 IF (.NOT.(a.EQ.aa)) GO TO 210
      genbet = w/(b+w)
      GO TO 220

  210 genbet = b/(b+w)
  220 CONTINUE

  230 RETURN
      END
c
c*********************************************************************
c
c Poisson variate (Numerical Recipes 1990, p. 207)
c
c*********************************************************************
c
      FUNCTION POIDEV(xm,idum)

c     ..Parameters..
      double precision  pi
      parameter        (pi=3.141592653589793d0)

c     ..Arguments..
      double precision  POIDEV,xm
      integer           idum

c     ..Local..
      double precision  oldm,g,em,t,sq,alxm,y

c     ..calling procedures..
      double precision RAN1,GAMMLN

      data oldm /-1.0d0/

      if (xm.lt.12.0d0)then
       if (xm.ne.oldm) then
        oldm=xm
        g=exp(-xm)
       endif

       em=-1.0d0
       t=1.0d0
2      em=em+1.0d0
       t=t*RAN1(idum)
       if (t.gt.g) go to 2

      else

       if (xm.ne.oldm) then
        oldm=xm
        sq=sqrt(2.0d0*xm)
        alxm=log(xm)
        g=xm*alxm-GAMMLN(xm+1.0d0)
       endif

1      y=tan(pi*RAN1(idum))
       em=sq*y+xm
       if (em.lt.0.0d0) go to 1
       em=int(em)
       t=0.9d0*(1.+y**2)*exp(em*alxm-GAMMLN(em+1.0d0)-g)
       if (RAN1(idum).gt.t) go to 1
      endif

      POIDEV=em

      RETURN
      END
c
c*********************************************************************
c
