c****************************CONTENTS********************************
c
c     FILMESS        - Output to file its description
c     INITLAB        - Initialization of labels
c     PRINTLM        - Screen output of selected iterations
c     PRINTAM        - File output of Averages of updates
c     PRINTDM        - File output of selected iterations
c
c********************************************************************
c
c   Output to file its description:
c   u is FORTRAN write unit
c   x(n) are index selections
c   fname is output file being described
c   parfil is parameter file input
c   distyp is distribution (i.e. Gamma, Normal, Dirichlet) and  
c     distch is distribution 1 or 2 (applicable to Gamma, Normal)
c   mess1 and mess3 are the parameter definitions
c     (i.e. Gamma mess1=shape,mess2=scale)
c
c********************************************************************
c
      SUBROUTINE FILMESS(u,n,x,fname,parfil,distyp,distch,mess1,mess2)

c     ..Arguments..
      integer          u,n,x(n),distch
      character*9      parfil
      character*10     distyp,mess1,mess2
      character*15     fname

c     ..Local..
      integer          j

      if ((distyp.eq.'Gamma').or.(distyp.eq.'Normal')) then
       write(u,'(6x,3a,1x,i5)')        distyp,' parameter updates -',
     *                                        ' Distribution',distch

       write(u,'(8x,2a)')                       'Column 1 is ',mess1
       write(u,'(8x,2a)')                       'Column 2 is ',mess2
       write(u,'(8x,2a)')         'Column 3 indicates occurrence of',
     *                                ' change-point  (yes=1,no=0).'

       write(u,'(/6x,2a)')                   'Scenario repeats over',
     *                                 ' selected iterations (rows)' 
       write(u,'(8x,3a/,8x,a,1x,i5,1x,2a)')             'defined in',
     *                                     ' parameter file ',parfil,
     *                      'and over a maximum of',n,'selected row',
     *                                         ' indices (columns):'
       write(u,'(/5x,10(1x,i5))')                       (x(j),j=1,n)

       write(u,'(/6x,3a/,11x,2a)')                'e.g. cell (17,4)',
     *                                      ' of output file ',fname,
     *                                'corresponds to 17th retained',
     *                               ' iteration and 2nd row index.'
       write(u,'(2(11x,2a/),2(11x,a/))') 
     *          '1st element of 2nd row index corresponds to ',mess1,
     *          '2nd element of 2nd row index corresponds to ',mess2,
     *           'and 3rd element of 2nd row index corresponds to a',
     *                            'change, if any, in distribution.'
      endif

      if (distyp.eq.'Dirichlet') then
       write(u,'(6x,2a)')              distyp,' parameter updates -'

       write(u,'(/6x,2a)')                   'Scenario repeats over',
     *                                 ' selected iterations (rows)' 
       write(u,'(8x,3a/,8x,a,1x,i5,1x,a)')             'defined in',
     *                                     ' parameter file ',parfil,
     *                   'and over a maximum of',n,'selected column'
       write(u,'(8x,a)')                        'indices (columns):'
       write(u,'(/5x,10(1x,i5))')                       (x(j),j=1,n)

       write(u,'(/6x,3a/,11x,2a)')                'e.g. cell (17,2)',
     *                                      ' of output file ',fname,
     *                                'corresponds to 17th retained',
     *                                              ' iteration and'
       write(u,'(11x,a)')                       '2nd  column index.'
       write(u,'(3(11x,a/))')     'NOTE: Each row sum equals to the',
     *                          'number of rows in data matrix and ',
     *                  'the sum of the Dirichlet prior parameters.'
      endif

      if (distyp.eq.'no change') then
       write(u,'(6x,a)')               'Probability of no change - '
       write(u,'(6x,a)')    '(Multinomial generation from Dirichlet'
       write(u,'(7x,a)')                        ' parameter update)'
       write(u,'(/6x,2a)')                   'Scenario repeats over',
     *                                        ' selected iterations'
       write(u,'(8x,a)')          'where multinomial probability is'
       write(u,'(8x,a)')   'assigned to last column of data matrix.'
      endif

      if (distyp.eq.'avgexp') then
       write(u,'(6x,a)')             'Expected values at each row -'
       write(u,'(8x,2a)')                parfil,' parameter updates'
       write(u,'(8x,2a)')     'Distribution 1 is sample X1 prior to',
     *                                              ' change-point.'
       write(u,'(8x,2a)')        'Distribution 2 is sample X2 after',
     *                                              ' change-point.'
       write(u,'(8x,2a)')                'Results are averaged over',
     *                                       ' selected iterations.'
       write(u,'(//a10,a35/)')     '', '----- Expected Values -----'
       write(u,'(a10,2(5x,a14))')             'Row','Distribution 1',
     *                                              'Distribution 2'
      endif

      if (distyp.eq.'davgexp') then
       write(u,'(6x,2a)')   'Difference between two expected values',
     *                                              ' at each row -'
       write(u,'(8x,2a)')                parfil,' parameter updates'
       write(u,'(8x,2a)')     'Distribution 1 is sample X1 prior to',
     *                                              ' change-point.'
       write(u,'(8x,2a)')        'Distribution 2 is sample X2 after',
     *                                              ' change-point.'
       write(u,'(8x,2a)')          'NOTE: Operation is in direction',
     *                                             ' E(X2) - E(X1).'
       write(u,'(//a10,a60/)')                                   ' ',
     *               '----- Difference in Two Expected Values -----'
       write(u,'(a10,3(5x,a14))')   ' ',' ','Change-point','Average'
       write(u,'(a10,3(5x,a14))')    'Row','Sum','Count','Sum/Count'
      endif

      if (distyp.eq.'avgdir') then
       write(u,'(6x,a)')     'Dirichlet parameter updates average -'
       write(u,'(8x,2a)')            'Each column is divided by the',
     *                             ' number of selected iterations;'
       write(u,'(8x,2a)')        'the result is then divided by the',
     *                                     ' sum of Dirichlet prior'
       write(u,'(8x,2a)')           'parameters plus number of rows',
     *                                            ' in data matrix.'
      endif

      write(u,'(/)')

      RETURN
      END
c
c********************************************************************
c
c
c     Header initialization for PRINTLM
c
c********************************************************************
c

      SUBROUTINE INITLAB(scrntyp1,scrntyp2,scrntyp3,scrntyp4,
     1                   scrntyp5,scrntyp6,scrntyp7,scrntyp8,
     2                   disstyp1,disstyp2,disstyp3,disstyp4,
     3                   disstyp5,genupdt1,genupdt2,genupdt3,
     4                   genvara1,genvara2,genvara3,genvara4)

c     ..Arguments..
      character*25       scrntyp1,scrntyp2,scrntyp3,scrntyp4,
     *                   scrntyp5,scrntyp6,scrntyp7,scrntyp8,
     *                   disstyp1,disstyp2,disstyp3,disstyp4,
     *                   disstyp5,genupdt1,genupdt2,genupdt3,
     *                   genvara1,genvara2,genvara3,genvara4


c     ..names of subroutines..
      scrntyp1='poster'
      scrntyp2='updatdir'
      scrntyp3='updatmean'
      scrntyp4='updatgam'
      scrntyp5='rdiri'
      scrntyp6='gamdev'
      scrntyp7='updatnorm'
      scrntyp8='normdev'

c     ..Distribution type..
      disstyp1='Change-point'
      disstyp2='Dirichlet'
      disstyp3='Data mean'
      disstyp4='Gamma'
      disstyp5='Normal'

c     ..data generation, parameter updates or column position..
      genupdt1='column position'
      genupdt2='parameter updates'
      genupdt3='generation of variates:'

c     ..distribution of generated variates..
      genvara1=''
      genvara2='Multinomial'
      genvara3='Poisson'
      genvara4='Normal mean'

      RETURN
      END
c
c********************************************************************
c
c     Output to screen selected iterations
c     samp(n) - vector of row or column indices
c     x,y,ix are matrices of size m,k  (m=row or col,k=1,2)
c     type is character for screen output type
c     distyp,genup and genvara are character labels
c     iter integer denotes iteration number
c     mrc is integer for 'rows'=1 or 'columns'=2
c
c********************************************************************
c
      SUBROUTINE PRINTLM(type,distyp,genup,genvar,iter,mrc,
     *                   m,k,n,samp,x,y,ix)

c     ..Parameters..
      integer          lim
      parameter        (lim=5)

c     ..Arguments..
      integer          iter,mrc,m,k,n,samp(n),ix(m,k)
      double precision x(m,k),y(m,k)
      character*25     type,distyp,genup,genvar
      

c     ..Local..
      integer          i,j
      character*25     selmn


c     ..INITIALIZE

c     ..Initialize in ITPROJ before ITERATIONS
      if ((mrc.lt.1).or.(mrc.gt.2)) STOP ' PRINTLM (ITPROJ)'
      selmn              ='at selected rows:'
      if (mrc.eq.2) selmn='at selected columns:'

      write(6,'(1x,i9,2a)')       iter,'th iteration - ',distyp
      write(6,'(10x,2a)')                          genup,genvar
      write(6,'(10x,a)')                                  selmn


c     ..PRINT TO SCREEN according to type..

      if (type.eq.'poster') then
       if (n.gt.lim) then
        write(6,'(/5(1x,i12.1))')              (samp(j),j=1,lim)
        write(6,'(5(1x,i12.1))')         (ix(samp(j),1),j=1,lim)
        write(6,'(/5(1x,i12.1))')            (samp(j),j=lim+1,n)
        write(6,'(5(1x,i12.1))')       (ix(samp(j),1),j=lim+1,n)
       else
        write(6,'(/5(1x,i12.1))')                (samp(j),j=1,n)
        write(6,'(5(1x,i12.1))')           (ix(samp(j),1),j=1,n)
       endif

      elseif (type.eq.'updatgam') then
       write(6,'(/1x,a8,2(1x,a28))')       'Row','Distribution 1',
     *                                           'Distribution 2'
       write(6,'(1x,a8,4(1x,a15))')       'Index','shape','scale',
     *                                            'shape','scale'
       do 10 j=1,n
         write(6,'(1x,i8.1,4(1x,e15.5))')                samp(j),
     *                                 x(samp(j),1),y(samp(j),1),
     *                                 x(samp(j),2),y(samp(j),2)
   10  continue

      elseif (type.eq.'updatnorm') then
       write(6,'(/1x,a8,2(1x,a28))')       'Row','Distribution 1',
     *                                           'Distribution 2'
       write(6,'(1x,a8,4(1x,a15))')     'Index','mean','variance',
     *                                          'mean','variance'
       do 20 j=1,n
        write(6,'(1x,i8.1,4(1x,e15.5))')                 samp(j),
     *                                 x(samp(j),1),y(samp(j),1),
     *                                 x(samp(j),2),y(samp(j),2)
   20   continue


      elseif ((type.eq.'rdiri').or.(type.eq.'updatdir')) then
       if (n.gt.lim) then
        write(6,'(/5(1x,i12.1))')              (samp(j),j=1,lim)
        write(6,'(5(1x,e12.5))')          (x(samp(j),1),j=1,lim)
        write(6,'(/5(1x,i12.1))')            (samp(j),j=lim+1,n)
        write(6,'(5(1x,e12.5))')        (x(samp(j),1),j=lim+1,n)
       else
        write(6,'(/5(1x,i12.1))')                (samp(j),j=1,n)
        write(6,'(5(1x,e12.5))')            (x(samp(j),1),j=1,n)
       endif


      elseif ((type.eq.'normdev').or.(type.eq.'gamdev').
     *    or.(type.eq.'updatmean')) then

       write(6,'(/3(1x,a15))')       'Row index','Distribution 1',
     *                                           'Distribution 2'

       do 30 i=1,n
        write(6,'(1x,i15.1,2(1x,e15.5))')                samp(i),
     *                                      (x(samp(i),j),j=1,2)
   30  continue


      else

       STOP ' Screen output ERROR in PRINTLM (ITPROJ)'

      endif

      write(6,'(/)')

      RETURN
      END
c
c********************************************************************
c
c     Output to file average updates:
c     u is FORTRAN write unit
c     fileout is file output name
c     partyp and headtyp are headers
c     index(nsamp) is index selection of size nsamp
c     m is number of rows or columns (depending on problem)
c     dvec1(n), dvec2(n), ivec1(n) are vectors of results
c     iter is number of selected iterations
c     netsum and netcnt are difference sums between F1 and F2 when
c      a change in distribution occurs  
c
c*********************************************************************
c
      SUBROUTINE PRINTAM(u,fileout,partyp,headtyp,nsamp,index,
     *                   m,n,dvec1,dvec2,iter,ivec1,netsum,netcnt)

c     ..Parameter..
      integer          izero
      double precision zero
      parameter       (izero=0,zero=0.0d0)

c     ..Arguments..
      integer          u,nsamp,m,n,iter,netcnt,
     *                 index(nsamp),ivec1(n)
      double precision netsum,dvec1(n),dvec2(n)
      character*10     partyp,headtyp
      character*15     fileout

c     ..Local..
      integer          i
      double precision sumdir,diter,rnetsum

c     ..Calling procedures..
c     FILMESS                                 !file header

c     ..INITIALIZATION..

      diter = dble(iter)
      open(u,file=fileout)


c     ..DIRICHLET UPDATES..

      if (headtyp.eq.'avgdir') then 

       sumdir = zero
       do 10 i = 1,n
        sumdir = sumdir + dvec1(i)
  10   continue
       sumdir = sumdir + dble(m)

       do 20 i = 1,n
        dvec2(i) = dvec2(i)/(diter*sumdir)
  20   continue

       call FILMESS(u,nsamp,index,fileout,headtyp,headtyp)

       write(13,'(5(1x,e12.5))') (dvec2(i),i=1,n)  

c     ..AVERAGED EXPECTED VALUES..

      elseif (headtyp.eq.'avgexp') then

       call FILMESS(u,nsamp,index,fileout,partyp,headtyp)

       do 50 i = 1,n 
        write(u,'(i10,5x,2(e12.5,7x))')                 i,
     *                      dvec1(i)/diter,dvec2(i)/diter
  50   continue

      elseif (headtyp.eq.'davgexp') then 

c      ..E(X2)-E(X1) DISTRIBUTION parameter UPDATE..


       rnetsum = zero
       if (netcnt.gt.izero)    rnetsum=netsum/dble(netcnt)

       call FILMESS(u,nsamp,index,fileout,partyp,headtyp)

       do 70 i = 1,n
        if (ivec1(i).gt.izero) then
         write(u,'(i10,7x,e12.5,5x,i14,7x,e12.5)')      i,
     *                                  dvec1(i),ivec1(i),
     *                            dvec1(i)/dble(ivec1(i))
        else
         write(u,'(i10,7x,e12.5,5x,i14,7x,e12.5)') i,zero,
     *                                          zero,zero 
        endif
   70  continue

       write(u,'(/e12.5,6x,a)')         netsum,'Total sum'
       write(u,'(e12.5,6x,a)')  rnetsum,'Weighted average'
       write(u,'(i12,6x,a)')                       netcnt,
     *                         'Total change-point counts'
       write(u,'(i12,6x,a)')                       iter*n,
     *                       'Maximum change-point counts'

      else 

       STOP ' Screen output ERROR in PRINTAM (ITPROJ)'

      endif

      close(u)

      RETURN
      END
c
c*********************************************************************
c
c     Output to file updates at selected iterations
c     u is FORTRAN write unit
c     typ is for type of output: typ=1 (gammas, normals), 
c     typ=2 (dirichlets, pr no change)
c     index is selection vector of size nind
c     dj is distribution index (dj=1,dj=2) for gammas,normals
c      and write unit for pr no change
c     change is change-point (yes=1,no=0)
c     upd1,upd2 are update matrices of n rows by m columns
c
c*********************************************************************
c
      SUBROUTINE PRINTDM(u,typ,n,m,nind,index,upd1,upd2,dj,change)

c     ..Arguments..
      integer          u,typ,n,dj,n,m,nind,index(nind),change(nind)
      double precision upd1(n,m),upd2(n,m)

c     ..Local..
      integer          i


c     .. GAMMA and NORMAL UPDATES

      if (typ.gt.0) then
       write(u,'(10(2(5x,e12.5),5x,i1))')
     *  (upd1(index(i),dj),upd2(index(i),dj),change(i),i=1,nind)
      else

c     .. DIRICHLET UPDATES and PR NO CHANGE

       write(u,'(10(1x,e12.5))') (upd1(index(i),1),i=1,nind)
       write(dj,'(5x,e12.5)') upd2(n,1)
      endif

      RETURN
      END
c
c*********************************************************************
c


