c****************************CONTENTS*********************************
c
c    ITPROJ   - Iterative parameter updates
c
c*********************************************************************
c version POISSON 
     
      SUBROUTINE ITPROJ(iseed,mult,multf,m,n,jd,nrow,
     1                  ncol,S,filecnt,countf,
     2                  cord,nvar,X,tau,pr,pd,pn,
     3                  lamb,agam,nagam,bgam,nbgam,
     4                  alpha,nalpha,
     5                  gm1,gm2,snalp,
     6                  samprow,sampcol,ind,
     7                  tmpm,tmpn1,tmpn2,tmpn3,itmpn,
     8                  rsmnmu,rctnmu,MISSING,opendirf,opengamf,
     9                  mpcavgd,mpcgexp,mpcndif,mpcpnch)

c     ..Parameters..
      double precision  EPS,zero
      parameter        (EPS=1.22d-307,zero=0.0d0)

c     ..Scalar arguments..
      integer          iseed,mult,multf,m,n,jd,S,
     *                 nrow,ncol,filecnt,countf
      logical          MISSING,opendirf,opengamf
      character*15     mpcavgd,mpcgexp,
     *                 mpcndif,                !avg expctd dist diffs
     *                 mpcpnch                         !Pr(no change)

c     ..Array arguments..
      integer          cord(m,n),tau(m),samprow(nrow),
     *                 sampcol(ncol),ind(nrow),nvar(m),
     *                 rctnmu(m),          !row counter for mean upd
     *                 X(m,n)
      double precision pr(m,n),pd(m),pn(n),
     *                 alpha(n),nalpha(n),                !dirichlet
     *                 agam(m,2),nagam(m,2),              !a1,a2 Gam
     *                 bgam(m,2),nbgam(m,2),              !b1,b2 Gam
     *                 lamb(m,2),                   !lamb~Gamma(a,b)
c
c
c
c
     *                 snalp(n),                    !avg dir updates
     *                 gm1(m),gm2(m),                 !E(X),X~G(a,b)
     *                 rsmnmu(m)                  !row sums of upgam

c     ..Dummy array arguments..
      integer          itmpn(n)
      double precision tmpm(m),tmpn1(n),tmpn2(n),tmpn3(n)

c     ..Local scalars..
      integer          i,j,l,l1,l1mult,ctnmu               !counters
      double precision smnmu                   !sums for differences
      character*10     partyp,headtyp                !identify files
      character*25     scrntyp1,scrntyp2,scrntyp3,scrntyp4,
     *                 scrntyp5,scrntyp6,scrntyp7,scrntyp8,
     *                 disstyp1,disstyp2,disstyp3,disstyp4,
     *                 disstyp5,genupdt1,genupdt2,genupdt3,
     *                 genvara1,genvara2,genvara3,genvara4

c     ..Calling subroutines..RDIRI,GAMDEV,        !generate variates
c                            POSTER,         !posterior distribution
c                            FILLIN,            !fill missing values
c                            UPDATDIR,UPDATGAM,             !updates
c
c                            AVGDIF,          !mean diffs in updates
c                            FILMESS                    !file header
c                            PRINTLM                  !screen header
c                            PRINTAM        !Output averaged updates
c                            PRINTDM        !Output iterated updates
c                            INITLAB  !Initialize labels for PRINTLM

c     ..INITIALIZATION..

      smnmu = zero            !sum weighted diffs from Updated means
      ctnmu = 0                               !counter for sum diffs
      l  = 0                                   !for iteration counts
      l1 = 1                                       !for screen dumps
      l1mult = l1*mult                             !for screen dumps
      do 100 j = 1,n
       snalp(j) = zero               !to summarize Dirichlet updates
  100 continue
      do 105 i = 1,m
       gm1(i) = zero                     !to summarize E(X),X~G(a,b)
       gm2(i) = zero 
       tau(i) = int(nvar(i)/2)         !set arbitr to half samp size
       rsmnmu(i) = zero            !row sum diffs from Updated means
       rctnmu(i) = 0                       !counter for row um diffs
  105 continue

c     ..Headers for screen header..

      call INITLAB(scrntyp1,scrntyp2,scrntyp3,scrntyp4,
     1             scrntyp5,scrntyp6,scrntyp7,scrntyp8,
     2             disstyp1,disstyp2,disstyp3,disstyp4,disstyp5,
     3             genupdt1,genupdt2,genupdt3,
     4             genvara1,genvara2,genvara3,genvara4)









c     ..DIRICHLET GENERATION of Multinomial variates pn..
c     ..pn ~ Dirichlet(nalpha_1,...,nalpha_n)..

      call RDIRI(iseed,n,jd,nalpha,tmpn1,tmpn2,tmpn3,pn)

c     ..GAMMA GENERATION of Poisson variates lamb..
c     ..lamb_j ~ Gamma(nagam_j,nbgam_j), j=1,2

      call GAMDEV(iseed,m,EPS,nagam,nbgam,lamb)

c     ..FILL in missing values..
c
c     ..Updated row Poisson (lamb)..

      if (MISSING) 
     * call FILLIN(m,n,nvar,iseed,tau,lamb,cord,X)


c C.  MPCP PROJECT (repeat S times)

      do 250 l = 1,S

c     ..CHANGE-POINT COLUMN POSITION FROM POSTERIOR DISTRIBUTION..

       call POSTER(iseed,l,m,n,nvar,jd,
     *             EPS,X,pn,lamb,tmpn1,tmpm,itmpn,
     *             pd,pr,tau)


c     ..UPDATES

c     ..DIRICHLET parameter UPDATES nalpha..

       call UPDATDIR(m,n,jd,tau,alpha,nalpha)

c
c
c

c     ..GAMMA parameter UPDATES nagam,nbgam..

       call UPDATGAM(m,n,nvar,X,tau,
     *               agam,bgam,nagam,nbgam)


c     ..NEW GENERATION

c     ..DIRICHLET GENERATION of Multinomial variates pn..
c     ..pn ~ Dirichlet(nalpha_1,...,nalpha_n)..

       call RDIRI(iseed,n,jd,nalpha,tmpn1,tmpn2,tmpn3,pn)

c     ..GAMMA GENERATION of Poisson variates lamb..
c     ..lamb_j ~ Gamma(nagam_j,nbgam_j), j=1,2

       call GAMDEV(iseed,m,EPS,nagam,nbgam,lamb)

c
c
c
c
c
c
c
c
c

c      ..FILL IN missing values..
c      ..Updated row Poisson (lamb)..

       if (MISSING)
     *  call FILLIN(m,n,nvar,iseed,tau,lamb,cord,X)


c     ..AT SELECTED ITERATIONS..

       if (l.eq.filecnt) then

c      ..SUM UPDATES..

c      ..DIRICHLET parameter UPDATES

        do 160 i = 1,n 
         snalp(i) = snalp(i) + nalpha(i)
  160   continue

c       ..E(X1),E(X2) GAMMA parameter UPDATES..

        do 180 i = 1,m 
         gm1(i) = gm1(i) + nagam(i,1)*nbgam(i,1)
         gm2(i) = gm2(i) + nagam(i,2)*nbgam(i,2)
  180   continue

c      ..E(X2)-E(X1) NORMAL or GAMMA mean parameter UPDATE..
c      ..Exclude from calculation tau=last column..

        call AVGDIF(m,nvar,tau,nagam,nbgam,smnmu,ctnmu,
     *              rsmnmu,rctnmu)


c       ..WRITE TO DISK IF SPACE ALLOWS..

c       ..GAMMA or NORMAL parameter UPDATES..

        if (opengamf) then 

         do 190 i = 1,nrow
          if (tau(samprow(i)).lt.nvar(samprow(i))) then
           ind(i) = 1
          else
           ind(i) = 0
          endif
  190    continue
         call PRINTDM( 8,1,m,2,nrow,samprow,nagam,nbgam,1,ind)
         call PRINTDM( 9,1,m,2,nrow,samprow,nagam,nbgam,2,ind)



        endif                                           !opengamf


c       ..DIRICHLET parameter UPDATES and P(no change)

        if (opendirf) then

         call PRINTDM(10,0,n,1,ncol,sampcol,nalpha,pn,14)

        endif 

        filecnt = filecnt + multf

       endif                                        !l.eq.filecnt


c      ..SCREEN OUTPUT..

       if (l.eq.l1mult) then
        call PRINTLM(scrntyp1,disstyp1,genupdt1,genvara1,l,1,m,1,
     *                            nrow,samprow,nalpha,nalpha,tau)
        call PRINTLM(scrntyp2,disstyp2,genupdt2,genvara1,l,2,n,1,
     *                            ncol,sampcol,nalpha,nalpha,tau)
        call PRINTLM(scrntyp4,disstyp4,genupdt2,genvara1,l,1,m,2,
     *                            nrow,samprow, nagam, nbgam,tau)
        call PRINTLM(scrntyp5,disstyp2,genupdt3,genvara2,l,2,n,1,
     *                            ncol,sampcol,    pn,    pn,tau)
        call PRINTLM(scrntyp6,disstyp4,genupdt3,genvara3,l,1,m,2,
     *                            nrow,samprow,  lamb,  lamb,tau)
c
c
c
c
c
c
       endif


c      ..INCREMENT COUNTERS..

       if (l.eq.1) write(6,'(/4x,i12,a/)') l,'st iteration done'
       if (l.eq.l1mult) then
        if (l.gt.1) write(6,'(4x,i12,a/)') l,'th iteration done'
        l1 = l1 + 1
        l1mult=l1*mult
       endif

  250 continue                                     !iterations


c     ..OUTPUT AVERAGES OVER SELECTED ITERATIONS..

c     ..EXPECTED GAMMA UPDATES..

      partyp='Gamma'
      headtyp='avgexp'
      call PRINTAM(13,mpcgexp,partyp,headtyp,ncol,
     *             sampcol,n,m,gm1,gm2,countf)


c      ..E(X2)-E(X1) UPDATE..
      partyp='Gamma'
      headtyp='davgexp'
      call PRINTAM(13,mpcndif,partyp,headtyp,ncol,
     *             sampcol,n,m,rsmnmu,gm2,countf,
     *             rctnmu,smnmu,ctnmu)


c     ..DIRICHLET UPDATES..

      headtyp='avgdir'
      call PRINTAM(13,mpcavgd,partyp,headtyp,ncol,
     *             sampcol,m,n,alpha,snalp,countf)


      RETURN
      END
c
c*********************************************************************
c
