c***************************CONTENTS********************************
c
c        UPDATDIR  : Dirichlet updates
c        UPDATGAM  : Gamma updates   
c
c 
c
c*******************************************************************
c
c      Update dirichlet parameters
c       tau(m) : Column position j=jd+1 to n,jd>=0,<n row i
c                (obtained from posterior distribution)
c       alp(n) : Initial vector of n Dirichlet parameters 
c      nalp(n) : Updated Dirichlet parameter vector
c
c*******************************************************************
c
      SUBROUTINE UPDATDIR(m,n,jd,tau,alp,nalp)

c     ..Scalar arguments..
      integer          m,n,jd

c     ..Array arguments..
      integer          tau(m)
      double precision alp(n),nalp(n)

c     ..Local scalars..
      integer          i,j,itau,jds

      jds = jd+1

      do 10 j = jds,n                     !Initialize alpha update
       nalp(j) = alp(j)
   10 continue

      do 40 i = 1,m                   !Update Dirichlet parameters
       itau = tau(i)
       do 20 j = jds,n
        if (itau.eq.j) GOTO 30
   20  continue
   30  nalp(j) = nalp(j) + 1.0d0
   40 continue

      RETURN
      END
c
c****************************************************************
c
c     Update Gamma parameters 
c      where E(X)=a*b
c      X(m,n) : integer data matrix
c      a,b,   : Initial Gamma parameters
c      tau(m) : Column position j=jd+1 to n,jd>=0,<n row 
c      na,nb  : Updated Gamma parameters na and nb 
c
c
c
c
c****************************************************************
c
      SUBROUTINE UPDATGAM(m,n,nvar,X,tau,a,b,na,nb)


c     ..Parameters..
      double precision zero,one
      parameter        (zero=0.0d0,one=1.0d0)

c     ..Scalar arguments..
      integer          m,n

c     ..Array arguments..
      integer          X(m,n),tau(m),nvar(m)
      double precision a(m,2),na(m,2),b(m,2),nb(m,2)


c     ..Local scalars..
      integer          i,j,itau,nv,sumXtotau,sumnX


      do 30 i = 1,m                        !for each row i of X

       itau = tau(i)
       nv   = nvar(i)
       sumXtotau = zero
c
c
c
c
c
c
c
c

       do 10 j = 1,itau                        !Sum row X to tau(i)
        sumXtotau = sumXtotau + X(i,j)
   10  continue
       sumnX = sumXtotau
c
c
c
c
c
c
c
c
c
c
c
        do 20 j = itau+1,nv           !Sum tau(i) of X to nvar(i)
         sumnX = sumnX + X(i,j)
   20   continue

c     ..Update parameter a of Gamma..

       na(i,1) = a(i,1) + sumXtotau
       na(i,2) = a(i,2) + sumnX - sumXtotau

c     ..Update parameter b of Gamma..

       nb(i,1) = one/(dble(itau)   + one/b(i,1))
       nb(i,2) = one/(dble(nv-itau)+ one/b(i,2))


   30 continue                               !for each row i=1,m

      RETURN
      END
c
c********************************************************************
c

